/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEventType;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.service.common.messaging.incoming.TraceEventConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TraceEventConsumer
extends BaseEventConsumer<TraceEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(TraceEventConsumer.class);
    private static final TypeReference<TraceEvent> CLOUD_EVENT_TYPE = new TypeReference<TraceEvent>(){};

    TraceEventConsumer() {
    }

    @Inject
    public TraceEventConsumer(TrustyService service, ObjectMapper mapper) {
        super(service, mapper);
    }

    @Override
    @Incoming(value="kogito-tracing-decision")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected void internalHandleCloudEvent(CloudEvent cloudEvent, TraceEvent payload) {
        TraceEventType traceEventType = payload.getHeader().getType();
        if (traceEventType == TraceEventType.DMN) {
            this.service.processDecision(cloudEvent.getId(), payload.getHeader().getResourceId().getServiceUrl(), TraceEventConverter.toDecision(payload, cloudEvent.getSource().toString()));
        } else {
            LOG.error("Unsupported TraceEvent type {}", (Object)traceEventType);
        }
    }

    @Override
    protected TypeReference<TraceEvent> getEventType() {
        return CLOUD_EVENT_TYPE;
    }
}

