/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.messaging.incoming;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.kogito.tracing.decision.event.message.Message;
import org.kie.kogito.tracing.decision.event.message.MessageExceptionField;
import org.kie.kogito.tracing.decision.event.message.MessageLevel;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceInputValue;
import org.kie.kogito.tracing.decision.event.trace.TraceOutputValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;

public class TraceEventConverter {
    private TraceEventConverter() {
    }

    public static Decision toDecision(TraceEvent event, String sourceUrl) {
        List<DecisionInput> inputs = event.getInputs() == null ? null : event.getInputs().stream().map(TraceEventConverter::toInput).collect(Collectors.toList());
        List<DecisionOutcome> outcomes = event.getOutputs() == null ? null : event.getOutputs().stream().map(TraceEventConverter::toOutcome).collect(Collectors.toList());
        return new Decision(event.getHeader().getExecutionId(), sourceUrl, event.getHeader().getStartTimestamp(), TraceEventConverter.decisionHasSucceeded(event.getOutputs()), null, event.getHeader().getResourceId().getModelName(), event.getHeader().getResourceId().getModelNamespace(), inputs, outcomes);
    }

    public static DecisionInput toInput(TraceInputValue eventInput) {
        return new DecisionInput(eventInput.getId(), eventInput.getName(), TraceEventConverter.toTypedVariable(eventInput.getName(), eventInput.getValue()));
    }

    public static TypedVariable toTypedVariable(String name, TypedValue typedVariable) {
        if (typedVariable == null) {
            return TypedVariable.buildUnit(name, null, null);
        }
        switch (typedVariable.getKind()) {
            case STRUCTURE: {
                return TypedVariable.buildStructure(name, typedVariable.getType(), Optional.ofNullable(typedVariable.toStructure().getValue()).map(v -> v.entrySet().stream().map(e -> TraceEventConverter.toTypedVariable((String)e.getKey(), (TypedValue)e.getValue())).collect(Collectors.toList())).orElse(null));
            }
            case COLLECTION: {
                return TypedVariable.buildCollection(name, typedVariable.getType(), Optional.ofNullable(typedVariable.toCollection().getValue()).map(v -> v.stream().map(x -> TraceEventConverter.toTypedVariable(null, x)).collect(Collectors.toList())).orElse(null));
            }
            case UNIT: {
                return TypedVariable.buildUnit(name, typedVariable.getType(), typedVariable.toUnit().getValue());
            }
        }
        throw new IllegalStateException("Unsupported TypedVariable of kind " + typedVariable.getKind());
    }

    public static DecisionOutcome toOutcome(TraceOutputValue eventOutput) {
        return new DecisionOutcome(eventOutput.getId(), eventOutput.getName(), eventOutput.getStatus(), TraceEventConverter.toTypedVariable(eventOutput.getName(), eventOutput.getValue()), eventOutput.getInputs() == null ? null : (Collection)eventOutput.getInputs().entrySet().stream().map(e -> TraceEventConverter.toTypedVariable((String)e.getKey(), (TypedValue)e.getValue())).collect(Collectors.toList()), eventOutput.getMessages() == null ? null : (Collection)eventOutput.getMessages().stream().map(TraceEventConverter::toMessage).collect(Collectors.toList()));
    }

    public static org.kie.kogito.trusty.storage.api.model.Message toMessage(Message eventMessage) {
        return new org.kie.kogito.trusty.storage.api.model.Message(eventMessage.getLevel(), eventMessage.getCategory() == null ? null : eventMessage.getCategory().name(), eventMessage.getType(), eventMessage.getSourceId(), eventMessage.getText(), TraceEventConverter.toMessageExceptionField(eventMessage.getException()));
    }

    public static org.kie.kogito.trusty.storage.api.model.MessageExceptionField toMessageExceptionField(MessageExceptionField eventException) {
        return eventException == null ? null : new org.kie.kogito.trusty.storage.api.model.MessageExceptionField(eventException.getClassName(), eventException.getMessage(), TraceEventConverter.toMessageExceptionField(eventException.getCause()));
    }

    public static boolean decisionHasSucceeded(List<TraceOutputValue> outputs) {
        return outputs != null && outputs.stream().noneMatch(o -> "failed".equalsIgnoreCase(o.getStatus()) || TraceEventConverter.messageListHasErrors(o.getMessages()));
    }

    private static boolean messageListHasErrors(List<Message> messages) {
        return messages != null && messages.stream().anyMatch(m -> m.getLevel() == MessageLevel.ERROR);
    }
}

