/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.redis;

import io.quarkus.runtime.Startup;
import io.redisearch.Schema;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.kie.kogito.persistence.redis.index.RedisCreateIndexEvent;
import org.kie.kogito.persistence.redis.index.RedisIndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class IndexProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexProvider.class);
    private RedisIndexManager indexManager;

    @Inject
    public IndexProvider(RedisIndexManager redisIndexManager) {
        this.indexManager = redisIndexManager;
    }

    @PostConstruct
    public void createIndexes() {
        LOGGER.debug("Creating redis indexes for Trusty Service.");
        this.createDecisionStorageIndex();
        this.createModelsStorageIndex();
        this.createExplainabilityResultsStorageIndex();
        LOGGER.debug("Creation of redis indexes completed.");
    }

    private void createDecisionStorageIndex() {
        RedisCreateIndexEvent decisionIndexEvent = new RedisCreateIndexEvent("decisions");
        decisionIndexEvent.withField(new Schema.Field("executionId", Schema.FieldType.FullText, false));
        decisionIndexEvent.withField(new Schema.Field("executionTimestamp", Schema.FieldType.Numeric, true));
        this.indexManager.createIndex(decisionIndexEvent);
    }

    private void createModelsStorageIndex() {
        RedisCreateIndexEvent modelIndexEvent = new RedisCreateIndexEvent("models");
        this.indexManager.createIndex(modelIndexEvent);
    }

    private void createExplainabilityResultsStorageIndex() {
        RedisCreateIndexEvent explainabilityIndexEvent = new RedisCreateIndexEvent("explainability-results");
        this.indexManager.createIndex(explainabilityIndexEvent);
    }
}

