/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.AsyncEventDeliveryStage;
import io.quarkus.arc.impl.EventObjectTypeResolverBuilder;
import io.quarkus.arc.impl.HierarchyDiscovery;
import io.quarkus.arc.impl.TypeResolver;
import io.quarkus.arc.impl.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import javax.enterprise.event.NotificationOptions;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.EventContext;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.TypeLiteral;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.logging.Logger;

class EventImpl<T>
implements Event<T> {
    private static final int DEFAULT_CACHE_CAPACITY = 4;
    private static final NotificationOptions EMPTY_OPTIONS = NotificationOptions.builder().build();
    private final HierarchyDiscovery injectionPointTypeHierarchy;
    private final Type eventType;
    private final Set<Annotation> qualifiers;
    private final ConcurrentMap<Class<?>, Notifier<? super T>> notifiers;
    private volatile transient Notifier<? super T> lastNotifier;

    EventImpl(Type eventType, Set<Annotation> qualifiers) {
        this.eventType = this.initEventType(eventType);
        this.injectionPointTypeHierarchy = new HierarchyDiscovery(this.eventType);
        this.qualifiers = qualifiers;
        this.qualifiers.add(Any.Literal.INSTANCE);
        this.notifiers = new ConcurrentHashMap(4);
    }

    @Override
    public void fire(T event) {
        Objects.requireNonNull(event, "Event cannot be null");
        this.getNotifier(event.getClass()).notify(event, ObserverExceptionHandler.IMMEDIATE_HANDLER, false);
    }

    @Override
    public <U extends T> CompletionStage<U> fireAsync(U event) {
        return this.fireAsync(event, EMPTY_OPTIONS);
    }

    @Override
    public <U extends T> CompletionStage<U> fireAsync(final U event, NotificationOptions options) {
        Objects.requireNonNull(options);
        final Notifier<T> notifier = this.getNotifier(event.getClass());
        Executor executor = options.getExecutor();
        if (executor == null) {
            executor = Arc.container().getExecutorService();
        }
        if (notifier.isEmpty()) {
            return AsyncEventDeliveryStage.completed(event, executor);
        }
        Supplier notifyLogic = new Supplier<U>(){

            @Override
            public U get() {
                CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
                notifier.notify(event, exceptionHandler, true);
                EventImpl.this.handleExceptions(exceptionHandler);
                return event;
            }
        };
        CompletableFuture completableFuture = CompletableFuture.supplyAsync(notifyLogic, executor);
        return new AsyncEventDeliveryStage(completableFuture, executor);
    }

    private Notifier<? super T> getNotifier(Class<?> runtimeType) {
        Notifier<? super T> notifier = this.lastNotifier;
        if (notifier != null && notifier.runtimeType.equals(runtimeType)) {
            return notifier;
        }
        this.lastNotifier = this.notifiers.computeIfAbsent(runtimeType, this::createNotifier);
        return this.lastNotifier;
    }

    @Override
    public Event<T> select(Annotation ... qualifiers) {
        HashSet<Annotation> mergedQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergedQualifiers, qualifiers);
        return new EventImpl<T>(this.eventType, mergedQualifiers);
    }

    @Override
    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> mergerdQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergerdQualifiers, qualifiers);
        return new EventImpl<T>(subtype, mergerdQualifiers);
    }

    @Override
    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> mergerdQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergerdQualifiers, qualifiers);
        return new EventImpl<T>(subtype.getType(), mergerdQualifiers);
    }

    private Notifier<? super T> createNotifier(Class<?> runtimeType) {
        Type eventType = this.getEventType(runtimeType);
        return EventImpl.createNotifier(runtimeType, eventType, this.qualifiers, ArcContainerImpl.unwrap(Arc.container()));
    }

    static <T> Notifier<T> createNotifier(Class<?> runtimeType, Type eventType, Set<Annotation> qualifiers, ArcContainerImpl container) {
        return EventImpl.createNotifier(runtimeType, eventType, qualifiers, container, true);
    }

    static <T> Notifier<T> createNotifier(Class<?> runtimeType, Type eventType, Set<Annotation> qualifiers, ArcContainerImpl container, boolean activateRequestContext) {
        EventMetadataImpl metadata = new EventMetadataImpl(qualifiers, eventType);
        ArrayList notifierObserverMethods = new ArrayList();
        for (ObserverMethod observerMethod : container.resolveObservers(eventType, qualifiers)) {
            notifierObserverMethods.add(observerMethod);
        }
        return new Notifier(runtimeType, notifierObserverMethods, metadata, activateRequestContext);
    }

    private Type initEventType(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && Event.class.isAssignableFrom(Types.getRawType((parameterizedType = (ParameterizedType)type).getRawType()))) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    private Type getEventType(Class<?> runtimeType) {
        Type resolvedType = runtimeType;
        if (Types.containsTypeVariable(resolvedType)) {
            resolvedType = this.injectionPointTypeHierarchy.resolveType(resolvedType);
        }
        if (Types.containsTypeVariable(resolvedType)) {
            Type canonicalEventType = Types.getCanonicalType(runtimeType);
            TypeResolver objectTypeResolver = new EventObjectTypeResolverBuilder(this.injectionPointTypeHierarchy.getResolver().getResolvedTypeVariables(), new HierarchyDiscovery(canonicalEventType).getResolver().getResolvedTypeVariables()).build();
            resolvedType = objectTypeResolver.resolveType(canonicalEventType);
        }
        return resolvedType;
    }

    private void handleExceptions(ObserverExceptionHandler handler) {
        List<Throwable> handledExceptions = handler.getHandledExceptions();
        if (!handledExceptions.isEmpty()) {
            CompletionException exception = null;
            if (handledExceptions.size() == 1) {
                exception = new CompletionException(handledExceptions.get(0));
            } else {
                exception = new CompletionException(null);
                for (Throwable handledException : handledExceptions) {
                    exception.addSuppressed(handledException);
                }
            }
            throw exception;
        }
    }

    static class CollectingExceptionHandler
    implements ObserverExceptionHandler {
        private List<Throwable> throwables;

        CollectingExceptionHandler() {
            this(new LinkedList<Throwable>());
        }

        CollectingExceptionHandler(List<Throwable> throwables) {
            this.throwables = throwables;
        }

        @Override
        public void handle(Throwable throwable) {
            this.throwables.add(throwable);
        }

        @Override
        public List<Throwable> getHandledExceptions() {
            return this.throwables;
        }
    }

    protected static interface ObserverExceptionHandler {
        public static final ObserverExceptionHandler IMMEDIATE_HANDLER = throwable -> {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new ObserverException(throwable);
        };

        public void handle(Throwable var1);

        default public List<Throwable> getHandledExceptions() {
            return Collections.emptyList();
        }
    }

    static enum Status {
        ALL{

            @Override
            public boolean matches(int status) {
                return true;
            }
        }
        ,
        SUCCESS{

            @Override
            public boolean matches(int status) {
                return status == 3;
            }
        }
        ,
        FAILURE{

            @Override
            public boolean matches(int status) {
                return status != 3;
            }
        };


        public abstract boolean matches(int var1);

        public static Status valueOf(TransactionPhase transactionPhase) {
            if (transactionPhase == TransactionPhase.BEFORE_COMPLETION || transactionPhase == TransactionPhase.AFTER_COMPLETION) {
                return ALL;
            }
            if (transactionPhase == TransactionPhase.AFTER_SUCCESS) {
                return SUCCESS;
            }
            if (transactionPhase == TransactionPhase.AFTER_FAILURE) {
                return FAILURE;
            }
            throw new IllegalArgumentException("Unknown transaction phase " + transactionPhase);
        }
    }

    static class DeferredEventNotification<T>
    implements Runnable {
        private ObserverMethod<? super T> observerMethod;
        private boolean isBeforeCompletion;
        private EventContext eventContext;
        private Status status;
        private static final Logger LOGGER = Logger.getLogger(DeferredEventNotification.class);

        DeferredEventNotification(ObserverMethod<? super T> observerMethod, EventContext eventContext, Status status) {
            this.observerMethod = observerMethod;
            this.isBeforeCompletion = observerMethod.getTransactionPhase().equals((Object)TransactionPhase.BEFORE_COMPLETION);
            this.eventContext = eventContext;
            this.status = status;
        }

        public boolean isBeforeCompletion() {
            return this.isBeforeCompletion;
        }

        public Status getStatus() {
            return this.status;
        }

        @Override
        public void run() {
            block6: {
                try {
                    ManagedContext reqContext = Arc.container().requestContext();
                    if (reqContext.isActive()) {
                        this.observerMethod.notify(this.eventContext);
                        break block6;
                    }
                    try {
                        reqContext.activate();
                        this.observerMethod.notify(this.eventContext);
                    }
                    finally {
                        reqContext.terminate();
                    }
                }
                catch (Exception e) {
                    LOGGER.errorf("Failure while notifying an observer %s for event %s. Stack trace - %s", (Object)this.observerMethod, (Object)this.eventContext.getMetadata().getType().getTypeName(), (Object)(e.getCause() != null ? e.getCause() : e));
                }
            }
        }
    }

    static class ArcSynchronization
    implements Synchronization {
        private List<DeferredEventNotification<?>> deferredEvents;

        ArcSynchronization(List<DeferredEventNotification<?>> deferredEvents) {
            this.deferredEvents = deferredEvents;
        }

        @Override
        public void beforeCompletion() {
            for (DeferredEventNotification<?> event : this.deferredEvents) {
                if (!event.isBeforeCompletion()) continue;
                event.run();
            }
        }

        @Override
        public void afterCompletion(int i) {
            for (DeferredEventNotification<?> event : this.deferredEvents) {
                if (event.isBeforeCompletion() || !event.getStatus().matches(i)) continue;
                event.run();
            }
        }
    }

    static class EventMetadataImpl
    implements EventMetadata {
        private final Set<Annotation> qualifiers;
        private final Type eventType;

        public EventMetadataImpl(Set<Annotation> qualifiers, Type eventType) {
            this.qualifiers = qualifiers;
            this.eventType = eventType;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public InjectionPoint getInjectionPoint() {
            return null;
        }

        @Override
        public Type getType() {
            return this.eventType;
        }
    }

    static class EventContextImpl<T>
    implements EventContext<T> {
        private final T payload;
        private final EventMetadata metadata;

        public EventContextImpl(T payload, EventMetadata metadata) {
            this.payload = payload;
            this.metadata = metadata;
        }

        @Override
        public T getEvent() {
            return this.payload;
        }

        @Override
        public EventMetadata getMetadata() {
            return this.metadata;
        }
    }

    static class Notifier<T> {
        private final Class<?> runtimeType;
        private final List<ObserverMethod<? super T>> observerMethods;
        private final EventMetadata eventMetadata;
        private final boolean hasTxObservers;
        private final boolean activateRequestContext;

        Notifier(Class<?> runtimeType, List<ObserverMethod<? super T>> observerMethods, EventMetadata eventMetadata) {
            this(runtimeType, observerMethods, eventMetadata, true);
        }

        Notifier(Class<?> runtimeType, List<ObserverMethod<? super T>> observerMethods, EventMetadata eventMetadata, boolean activateRequestContext) {
            this.runtimeType = runtimeType;
            this.observerMethods = observerMethods;
            this.eventMetadata = eventMetadata;
            this.hasTxObservers = observerMethods.stream().anyMatch(this::isTxObserver);
            this.activateRequestContext = activateRequestContext;
        }

        void notify(T event) {
            this.notify(event, ObserverExceptionHandler.IMMEDIATE_HANDLER, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notify(T event, ObserverExceptionHandler exceptionHandler, boolean async) {
            if (!this.isEmpty()) {
                Predicate<ObserverMethod<ObserverMethod>> predicate;
                block12: {
                    InstanceHandle<TransactionSynchronizationRegistry> registryInstance;
                    Predicate<ObserverMethod<ObserverMethod>> predicate2 = predicate = async ? ObserverMethod::isAsync : Predicate.not(ObserverMethod::isAsync);
                    if (!async && this.hasTxObservers && (registryInstance = Arc.container().instance(TransactionSynchronizationRegistry.class, new Annotation[0])).isAvailable() && registryInstance.get().getTransactionStatus() == 0) {
                        ArrayList deferredEvents = new ArrayList();
                        EventContextImpl<T> eventContext = new EventContextImpl<T>(event, this.eventMetadata);
                        for (ObserverMethod<T> om : this.observerMethods) {
                            if (!this.isTxObserver(om)) continue;
                            deferredEvents.add(new DeferredEventNotification<T>(om, eventContext, Status.valueOf(om.getTransactionPhase())));
                        }
                        ArcSynchronization sync = new ArcSynchronization(deferredEvents);
                        TransactionSynchronizationRegistry registry = registryInstance.get();
                        try {
                            registry.registerInterposedSynchronization(sync);
                            predicate = predicate.and(this::isNotTxObserver);
                        }
                        catch (Exception e) {
                            if (!(e.getCause() instanceof RollbackException) && !(e.getCause() instanceof IllegalStateException)) break block12;
                            predicate = predicate.and(this::isNotAfterSuccess);
                        }
                    }
                }
                if (this.activateRequestContext) {
                    ManagedContext requestContext = Arc.container().requestContext();
                    if (requestContext.isActive()) {
                        this.notifyObservers(event, exceptionHandler, predicate);
                    } else {
                        try {
                            requestContext.activate();
                            this.notifyObservers(event, exceptionHandler, predicate);
                        }
                        finally {
                            requestContext.terminate();
                        }
                    }
                } else {
                    this.notifyObservers(event, exceptionHandler, predicate);
                }
            }
        }

        private void notifyObservers(T event, ObserverExceptionHandler exceptionHandler, Predicate<ObserverMethod<? super T>> predicate) {
            EventContextImpl<T> eventContext = new EventContextImpl<T>(event, this.eventMetadata);
            for (ObserverMethod<T> observerMethod : this.observerMethods) {
                if (!predicate.test(observerMethod)) continue;
                try {
                    observerMethod.notify(eventContext);
                }
                catch (Throwable e) {
                    exceptionHandler.handle(e);
                }
            }
        }

        boolean isEmpty() {
            return this.observerMethods.isEmpty();
        }

        private boolean isTxObserver(ObserverMethod<?> observer) {
            return !observer.getTransactionPhase().equals((Object)TransactionPhase.IN_PROGRESS);
        }

        private boolean isNotAfterSuccess(ObserverMethod<?> observer) {
            return !observer.getTransactionPhase().equals((Object)TransactionPhase.AFTER_SUCCESS);
        }

        private boolean isNotTxObserver(ObserverMethod<?> observer) {
            return !this.isTxObserver(observer);
        }
    }
}

