/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class HttpAuthenticator {
    final HttpAuthenticationMechanism[] mechanisms;
    @Inject
    IdentityProviderManager identityProviderManager;
    @Inject
    Instance<PathMatchingHttpSecurityPolicy> pathMatchingPolicy;

    public HttpAuthenticator() {
        this.mechanisms = null;
    }

    @Inject
    public HttpAuthenticator(Instance<HttpAuthenticationMechanism> instance, Instance<IdentityProvider<?>> providers) {
        ArrayList<HttpAuthenticationMechanism> mechanisms = new ArrayList<HttpAuthenticationMechanism>();
        for (HttpAuthenticationMechanism mechanism : instance) {
            boolean notFound = false;
            for (Class<? extends AuthenticationRequest> mechType : mechanism.getCredentialTypes()) {
                boolean found = false;
                for (IdentityProvider identityProvider : providers) {
                    if (!identityProvider.getRequestType().equals(mechType)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                notFound = true;
                break;
            }
            if (notFound) continue;
            mechanisms.add(mechanism);
        }
        if (mechanisms.isEmpty()) {
            this.mechanisms = new HttpAuthenticationMechanism[]{new NoAuthenticationMechanism()};
        } else {
            this.mechanisms = mechanisms.toArray(new HttpAuthenticationMechanism[mechanisms.size()]);
            HashMap<HttpCredentialTransport, HttpAuthenticationMechanism> map = new HashMap<HttpCredentialTransport, HttpAuthenticationMechanism>();
            for (HttpAuthenticationMechanism i : mechanisms) {
                HttpCredentialTransport credentialTransport = i.getCredentialTransport();
                if (credentialTransport == null) continue;
                HttpAuthenticationMechanism existing = (HttpAuthenticationMechanism)map.get(credentialTransport);
                if (existing != null) {
                    throw new RuntimeException("Multiple mechanisms present that use the same credential transport " + credentialTransport + ". Mechanisms are " + i + " and " + existing);
                }
                map.put(credentialTransport, i);
            }
        }
    }

    IdentityProviderManager getIdentityProviderManager() {
        return this.identityProviderManager;
    }

    public Uni<SecurityIdentity> attemptAuthentication(final RoutingContext routingContext) {
        String pathSpecificMechanism = this.pathMatchingPolicy.isResolvable() ? ((PathMatchingHttpSecurityPolicy)this.pathMatchingPolicy.get()).getAuthMechanismName(routingContext) : null;
        HttpAuthenticationMechanism matchingMech = this.findBestCandidateMechanism(routingContext, pathSpecificMechanism);
        if (matchingMech != null) {
            routingContext.put(HttpAuthenticationMechanism.class.getName(), matchingMech);
            return matchingMech.authenticate(routingContext, this.identityProviderManager);
        }
        if (pathSpecificMechanism != null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        Uni<SecurityIdentity> result = this.mechanisms[0].authenticate(routingContext, this.identityProviderManager);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni(new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(SecurityIdentity data) {
                    if (data != null) {
                        return Uni.createFrom().item(data);
                    }
                    return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
                }
            });
        }
        return result;
    }

    public Uni<Boolean> sendChallenge(final RoutingContext routingContext) {
        Uni<Boolean> result = null;
        HttpAuthenticationMechanism matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName());
        if (matchingMech != null) {
            result = matchingMech.sendChallenge(routingContext);
        }
        if (result == null) {
            result = this.mechanisms[0].sendChallenge(routingContext);
            for (int i = 1; i < this.mechanisms.length; ++i) {
                final HttpAuthenticationMechanism mech = this.mechanisms[i];
                result = result.onItem().transformToUni(new Function<Boolean, Uni<? extends Boolean>>(){

                    @Override
                    public Uni<? extends Boolean> apply(Boolean authDone) {
                        if (authDone.booleanValue()) {
                            return Uni.createFrom().item(authDone);
                        }
                        return mech.sendChallenge(routingContext);
                    }
                });
            }
        }
        return result.onItem().transformToUni(new Function<Boolean, Uni<? extends Boolean>>(){

            @Override
            public Uni<? extends Boolean> apply(Boolean authDone) {
                if (!authDone.booleanValue()) {
                    routingContext.response().setStatusCode(401);
                    routingContext.response().end();
                }
                return Uni.createFrom().item(authDone);
            }
        });
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName());
        if (matchingMech != null) {
            return matchingMech.getChallenge(routingContext);
        }
        Uni<ChallengeData> result = this.mechanisms[0].getChallenge(routingContext);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni(new Function<ChallengeData, Uni<? extends ChallengeData>>(){

                @Override
                public Uni<? extends ChallengeData> apply(ChallengeData data) {
                    if (data != null) {
                        return Uni.createFrom().item(data);
                    }
                    return mech.getChallenge(routingContext);
                }
            });
        }
        return result;
    }

    private HttpAuthenticationMechanism findBestCandidateMechanism(RoutingContext routingContext, String pathSpecificMechanism) {
        block3: {
            block2: {
                if (pathSpecificMechanism == null) break block2;
                for (int i = 0; i < this.mechanisms.length; ++i) {
                    HttpCredentialTransport credType = this.mechanisms[i].getCredentialTransport();
                    if (credType == null || !credType.getAuthenticationScheme().equalsIgnoreCase(pathSpecificMechanism)) continue;
                    return this.mechanisms[i];
                }
                break block3;
            }
            String authScheme = HttpAuthenticator.getAuthorizationScheme(routingContext);
            if (authScheme == null) break block3;
            for (int i = 0; i < this.mechanisms.length; ++i) {
                HttpCredentialTransport credType = this.mechanisms[i].getCredentialTransport();
                if (credType == null || credType.getTransportType() != HttpCredentialTransport.Type.AUTHORIZATION || !credType.getTypeTarget().toLowerCase().startsWith(authScheme.toLowerCase())) continue;
                return this.mechanisms[i];
            }
        }
        return null;
    }

    private static String getAuthorizationScheme(RoutingContext routingContext) {
        int spaceIndex;
        String authorization = routingContext.request().getHeader(HttpHeaders.AUTHORIZATION);
        if (authorization != null && (spaceIndex = authorization.indexOf(32)) > 0) {
            return authorization.substring(0, spaceIndex);
        }
        return null;
    }

    static class NoopCloseTask
    implements Runnable {
        static final NoopCloseTask INSTANCE = new NoopCloseTask();

        NoopCloseTask() {
        }

        @Override
        public void run() {
        }
    }

    static class NoAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        NoAuthenticationMechanism() {
        }

        @Override
        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return Uni.createFrom().optional(Optional.empty());
        }

        @Override
        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            ChallengeData challengeData = new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null);
            return Uni.createFrom().item(challengeData);
        }

        @Override
        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Collections.singleton(AnonymousAuthenticationRequest.class);
        }

        @Override
        public HttpCredentialTransport getCredentialTransport() {
            return null;
        }
    }
}

