/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.paths;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.operation.OperationWriter;
import io.smallrye.openapi.runtime.io.parameter.ParameterWriter;
import io.smallrye.openapi.runtime.io.server.ServerWriter;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

public class PathsWriter {
    private PathsWriter() {
    }

    public static void writePaths(ObjectNode parent, Paths paths) {
        if (paths == null) {
            return;
        }
        ObjectNode pathsNode = parent.putObject("paths");
        if (paths.getPathItems() != null) {
            Set<Map.Entry<String, PathItem>> entrySet = paths.getPathItems().entrySet();
            for (Map.Entry<String, PathItem> entry : entrySet) {
                PathsWriter.writePathItem(pathsNode, entry.getValue(), entry.getKey());
            }
        }
        ExtensionWriter.writeExtensions(pathsNode, paths);
    }

    public static void writePathItem(ObjectNode parent, PathItem model, String pathName) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(pathName);
        JsonUtil.stringProperty(node, "$ref", model.getRef());
        JsonUtil.stringProperty(node, "summary", model.getSummary());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        OperationWriter.writeOperation(node, model.getGET(), "get");
        OperationWriter.writeOperation(node, model.getPUT(), "put");
        OperationWriter.writeOperation(node, model.getPOST(), "post");
        OperationWriter.writeOperation(node, model.getDELETE(), "delete");
        OperationWriter.writeOperation(node, model.getOPTIONS(), "options");
        OperationWriter.writeOperation(node, model.getHEAD(), "head");
        OperationWriter.writeOperation(node, model.getPATCH(), "patch");
        OperationWriter.writeOperation(node, model.getTRACE(), "trace");
        ParameterWriter.writeParameterList(node, model.getParameters());
        ServerWriter.writeServers(node, model.getServers());
        ExtensionWriter.writeExtensions(node, model);
    }
}

