/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.OidcProviderClient;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OidcRecorder {
    private static final Logger LOG = Logger.getLogger(OidcRecorder.class);
    private static final String DEFAULT_TENANT_ID = "Default";
    private static final Map<String, TenantConfigContext> dynamicTenantsConfig = new ConcurrentHashMap<String, TenantConfigContext>();

    public Supplier<DefaultTokenIntrospectionUserInfoCache> setupTokenCache(OidcConfig config, Supplier<Vertx> vertx) {
        return () -> new DefaultTokenIntrospectionUserInfoCache(config, (Vertx)vertx.get());
    }

    public Supplier<TenantConfigBean> setup(OidcConfig config, Supplier<Vertx> vertx, final TlsConfig tlsConfig) {
        final Vertx vertxValue = vertx.get();
        String defaultTenantId = config.defaultTenant.getTenantId().orElse(DEFAULT_TENANT_ID);
        final TenantConfigContext defaultTenantContext = this.createStaticTenantContext(vertxValue, config.defaultTenant, tlsConfig, defaultTenantId);
        final HashMap<String, TenantConfigContext> staticTenantsConfig = new HashMap<String, TenantConfigContext>();
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants.entrySet()) {
            OidcCommonUtils.verifyConfigurationId(defaultTenantId, tenant.getKey(), tenant.getValue().getTenantId());
            staticTenantsConfig.put(tenant.getKey(), this.createStaticTenantContext(vertxValue, tenant.getValue(), tlsConfig, tenant.getKey()));
        }
        return new Supplier<TenantConfigBean>(){

            @Override
            public TenantConfigBean get() {
                return new TenantConfigBean(staticTenantsConfig, dynamicTenantsConfig, defaultTenantContext, new Function<OidcTenantConfig, Uni<TenantConfigContext>>(){

                    @Override
                    public Uni<TenantConfigContext> apply(OidcTenantConfig config) {
                        return OidcRecorder.this.createDynamicTenantContext(vertxValue, config, tlsConfig, config.getTenantId().get());
                    }
                }, ExecutorRecorder.getCurrent());
            }
        };
    }

    private Uni<TenantConfigContext> createDynamicTenantContext(Vertx vertx, OidcTenantConfig oidcConfig, TlsConfig tlsConfig, final String tenantId) {
        if (!dynamicTenantsConfig.containsKey(tenantId)) {
            Uni<TenantConfigContext> uniContext = this.createTenantContext(vertx, oidcConfig, tlsConfig, tenantId);
            uniContext.onFailure().transform(t -> OidcRecorder.logTenantConfigContextFailure(t, tenantId));
            return uniContext.onItem().transform(new Function<TenantConfigContext, TenantConfigContext>(){

                @Override
                public TenantConfigContext apply(TenantConfigContext t) {
                    dynamicTenantsConfig.putIfAbsent(tenantId, t);
                    return t;
                }
            });
        }
        return Uni.createFrom().item(dynamicTenantsConfig.get(tenantId));
    }

    private TenantConfigContext createStaticTenantContext(Vertx vertx, final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, final String tenantId) {
        Uni<TenantConfigContext> uniContext = this.createTenantContext(vertx, oidcConfig, tlsConfig, tenantId);
        return uniContext.onFailure().recoverWithItem(new Function<Throwable, TenantConfigContext>(){

            @Override
            public TenantConfigContext apply(Throwable t) {
                if (t instanceof OIDCException) {
                    LOG.debugf("Tenant '%s': '%s'. Access to resources protected by this tenant may fail if OIDC server will not become available", (Object)tenantId, (Object)t.getMessage());
                    return new TenantConfigContext(null, oidcConfig, false);
                }
                OidcRecorder.logTenantConfigContextFailure(t, tenantId);
                if (t instanceof ConfigurationException && !oidcConfig.authServerUrl.isPresent() && LaunchMode.DEVELOPMENT == LaunchMode.current()) {
                    return new TenantConfigContext(null, oidcConfig, false);
                }
                throw new OIDCException(t);
            }
        }).await().indefinitely();
    }

    private static Throwable logTenantConfigContextFailure(Throwable t, String tenantId) {
        LOG.debugf("'%s' tenant is not initialized: '%s'. Access to resources protected by this tenant will fail.", (Object)tenantId, (Object)t.getMessage());
        return t;
    }

    private Uni<TenantConfigContext> createTenantContext(Vertx vertx, OidcTenantConfig oidcConfig, TlsConfig tlsConfig, String tenantId) {
        if (!oidcConfig.tenantId.isPresent()) {
            oidcConfig.tenantId = Optional.of(tenantId);
        }
        if (!oidcConfig.tenantEnabled) {
            LOG.debugf("'%s' tenant configuration is disabled", (Object)tenantId);
            return Uni.createFrom().item(new TenantConfigContext(new OidcProvider(null, null, null), oidcConfig));
        }
        if (oidcConfig.getPublicKey().isPresent()) {
            return Uni.createFrom().item(OidcRecorder.createTenantContextFromPublicKey(oidcConfig));
        }
        try {
            OidcCommonUtils.verifyCommonConfiguration(oidcConfig, OidcRecorder.isServiceApp(oidcConfig), true);
        }
        catch (ConfigurationException t) {
            return Uni.createFrom().failure(t);
        }
        if (!oidcConfig.discoveryEnabled) {
            if (!(OidcRecorder.isServiceApp(oidcConfig) || oidcConfig.authorizationPath.isPresent() && oidcConfig.tokenPath.isPresent())) {
                throw new ConfigurationException("'web-app' applications must have 'authorization-path' and 'token-path' properties set when the discovery is disabled.", Set.of("quarkus.oidc.authorization-path", "quarkus.oidc.token-path"));
            }
            if (!oidcConfig.jwksPath.isPresent() && !oidcConfig.introspectionPath.isPresent()) {
                if (!oidcConfig.authentication.isIdTokenRequired() && oidcConfig.authentication.isUserInfoRequired()) {
                    LOG.debugf("tenant %s supports only UserInfo", (Object)oidcConfig.tenantId.get());
                } else {
                    throw new ConfigurationException("Either 'jwks-path' or 'introspection-path' properties must be set when the discovery is disabled.", Set.of("quarkus.oidc.jwks-path", "quarkus.oidc.introspection-path"));
                }
            }
        }
        if (OidcRecorder.isServiceApp(oidcConfig)) {
            if (oidcConfig.token.refreshExpired) {
                throw new ConfigurationException("The 'token.refresh-expired' property can only be enabled for " + OidcTenantConfig.ApplicationType.WEB_APP + " application types");
            }
            if (oidcConfig.logout.path.isPresent()) {
                throw new ConfigurationException("The 'logout.path' property can only be enabled for " + OidcTenantConfig.ApplicationType.WEB_APP + " application types");
            }
            if (oidcConfig.roles.source.isPresent() && oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.idtoken) {
                throw new ConfigurationException("The 'roles.source' property can only be set to 'idtoken' for " + OidcTenantConfig.ApplicationType.WEB_APP + " application types");
            }
        }
        if (oidcConfig.tokenStateManager.strategy != OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (oidcConfig.authentication.isUserInfoRequired() || oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.userinfo) {
                throw new ConfigurationException("UserInfo is required but DefaultTokenStateManager is configured to not keep the access token");
            }
            if (oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken) {
                throw new ConfigurationException("Access token is required to check the roles but DefaultTokenStateManager is configured to not keep the access token");
            }
        }
        return OidcRecorder.createOidcProvider(oidcConfig, tlsConfig, vertx).onItem().transform(p -> new TenantConfigContext((OidcProvider)p, oidcConfig));
    }

    private static TenantConfigContext createTenantContextFromPublicKey(OidcTenantConfig oidcConfig) {
        if (!OidcRecorder.isServiceApp(oidcConfig)) {
            throw new ConfigurationException("'public-key' property can only be used with the 'service' applications");
        }
        LOG.debug("'public-key' property for the local token verification is set, no connection to the OIDC server will be created");
        return new TenantConfigContext(new OidcProvider(oidcConfig.publicKey.get(), oidcConfig), oidcConfig);
    }

    public void setSecurityEventObserved(boolean isSecurityEventObserved) {
        DefaultTenantConfigResolver bean = Arc.container().instance(DefaultTenantConfigResolver.class, new Annotation[0]).get();
        bean.setSecurityEventObserved(isSecurityEventObserved);
    }

    public static Optional<ProxyOptions> toProxyOptions(OidcCommonConfig.Proxy proxyConfig) {
        return OidcCommonUtils.toProxyOptions(proxyConfig);
    }

    protected static OIDCException toOidcException(Throwable cause, String authServerUrl) {
        String message = OidcCommonUtils.formatConnectionErrorMessage(authServerUrl);
        return new OIDCException(message, cause);
    }

    protected static Uni<OidcProvider> createOidcProvider(final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, Vertx vertx) {
        return OidcRecorder.createOidcClientUni(oidcConfig, tlsConfig, vertx).onItem().transformToUni(new Function<OidcProviderClient, Uni<? extends OidcProvider>>(){

            @Override
            public Uni<OidcProvider> apply(final OidcProviderClient client) {
                if (client.getMetadata().getJsonWebKeySetUri() != null) {
                    return OidcRecorder.getJsonWebSetUni(client, oidcConfig).onItem().transform(new Function<JsonWebKeySet, OidcProvider>(){

                        @Override
                        public OidcProvider apply(JsonWebKeySet jwks) {
                            return new OidcProvider(client, oidcConfig, jwks);
                        }
                    });
                }
                return Uni.createFrom().item(new OidcProvider(client, oidcConfig, null));
            }
        });
    }

    protected static Uni<JsonWebKeySet> getJsonWebSetUni(OidcProviderClient client, OidcTenantConfig oidcConfig) {
        if (!oidcConfig.isDiscoveryEnabled()) {
            long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis(oidcConfig);
            return client.getJsonWebKeySet().onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(OidcCommonUtils.CONNECTION_BACKOFF_DURATION, OidcCommonUtils.CONNECTION_BACKOFF_DURATION).expireIn(connectionDelayInMillisecs).onFailure().transform(t -> OidcRecorder.toOidcException(t, (String)oidcConfig.authServerUrl.get())).invoke(client::close);
        }
        return client.getJsonWebKeySet();
    }

    protected static Uni<OidcProviderClient> createOidcClientUni(final OidcTenantConfig oidcConfig, TlsConfig tlsConfig, Vertx vertx) {
        final String authServerUriString = OidcCommonUtils.getAuthServerUrl(oidcConfig);
        WebClientOptions options = new WebClientOptions();
        OidcCommonUtils.setHttpClientOptions(oidcConfig, tlsConfig, options);
        final WebClient client = WebClient.create(new io.vertx.mutiny.core.Vertx(vertx), options);
        Uni<OidcConfigurationMetadata> metadataUni = null;
        if (!oidcConfig.discoveryEnabled) {
            String tokenUri = OidcCommonUtils.getOidcEndpointUrl(authServerUriString, oidcConfig.tokenPath);
            String introspectionUri = OidcCommonUtils.getOidcEndpointUrl(authServerUriString, oidcConfig.introspectionPath);
            String authorizationUri = OidcCommonUtils.getOidcEndpointUrl(authServerUriString, oidcConfig.authorizationPath);
            String jwksUri = OidcCommonUtils.getOidcEndpointUrl(authServerUriString, oidcConfig.jwksPath);
            String userInfoUri = OidcCommonUtils.getOidcEndpointUrl(authServerUriString, oidcConfig.userInfoPath);
            String endSessionUri = OidcCommonUtils.getOidcEndpointUrl(authServerUriString, oidcConfig.endSessionPath);
            metadataUni = Uni.createFrom().item(new OidcConfigurationMetadata(tokenUri, introspectionUri, authorizationUri, jwksUri, userInfoUri, endSessionUri, oidcConfig.token.issuer.orElse(null)));
        } else {
            long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis(oidcConfig);
            metadataUni = OidcCommonUtils.discoverMetadata(client, authServerUriString, connectionDelayInMillisecs).onItem().transform(json -> new OidcConfigurationMetadata((JsonObject)json));
        }
        return metadataUni.onItemOrFailure().transformToUni(new BiFunction<OidcConfigurationMetadata, Throwable, Uni<? extends OidcProviderClient>>(){

            @Override
            public Uni<OidcProviderClient> apply(OidcConfigurationMetadata metadata, Throwable t) {
                if (t != null) {
                    client.close();
                    return Uni.createFrom().failure(OidcRecorder.toOidcException(t, authServerUriString));
                }
                if (metadata == null) {
                    client.close();
                    return Uni.createFrom().failure(new ConfigurationException("OpenId Connect Provider configuration metadata is not configured and can not be discovered"));
                }
                if (oidcConfig.logout.path.isPresent() && !oidcConfig.endSessionPath.isPresent() && metadata.getEndSessionUri() == null) {
                    client.close();
                    return Uni.createFrom().failure(new ConfigurationException("The application supports RP-Initiated Logout but the OpenID Provider does not advertise the end_session_endpoint"));
                }
                return Uni.createFrom().item(new OidcProviderClient(client, metadata, oidcConfig));
            }
        });
    }

    private static boolean isServiceApp(OidcTenantConfig oidcConfig) {
        return OidcTenantConfig.ApplicationType.SERVICE.equals((Object)oidcConfig.applicationType);
    }
}

