/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.Expressions;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

final class Substitutions {
    static final FastThreadLocalInt notExpanding = FastThreadLocalFactory.createInt();

    Substitutions() {
    }

    @TargetClass(className="io.smallrye.config.ConfigMappingClass")
    static final class Target_ConfigMappingClass {
        @Alias
        static ClassValue<Target_ConfigMappingClass> cv = null;
        @Alias
        private Class<?> classType;
        @Alias
        private String interfaceName;

        @Substitute
        public static Target_ConfigMappingClass getConfigurationClass(Class<?> classType) {
            Assert.checkNotNullParam("classType", classType);
            try {
                return cv.get(classType);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Substitute
        @TargetElement(name="<init>")
        public Target_ConfigMappingClass(Class<?> classType) {
            this.classType = classType;
            this.interfaceName = classType.getPackage().getName() + "." + classType.getSimpleName() + classType.getName().hashCode() + "I";
        }

        @Substitute
        public byte[] getClassBytes() {
            return null;
        }
    }

    @TargetClass(className="io.smallrye.config.ConfigMappingInterface")
    static final class Target_ConfigMappingInterface {
        @Alias
        static ClassValue<Target_ConfigMappingInterface> cv = null;

        Target_ConfigMappingInterface() {
        }

        @Substitute
        public static Target_ConfigMappingInterface getConfigurationInterface(Class<?> interfaceType) {
            Assert.checkNotNullParam("interfaceType", interfaceType);
            try {
                return cv.get(interfaceType);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Substitute
        public byte[] getClassBytes() {
            return null;
        }
    }

    @TargetClass(className="io.smallrye.config.ConfigMappingLoader")
    static final class Target_ConfigMappingLoader {
        Target_ConfigMappingLoader() {
        }

        @Substitute
        static Class<?> loadClass(Class<?> parent, ConfigMappingMetadata configMappingMetadata) {
            try {
                return parent.getClassLoader().loadClass(configMappingMetadata.getClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        @Substitute
        private static Class<?> defineClass(Class<?> parent, String className, byte[] classBytes) {
            return null;
        }
    }

    @TargetClass(value=Expressions.class)
    static final class Target_Expressions {
        @Delete
        private static ThreadLocal<Boolean> ENABLE;

        Target_Expressions() {
        }

        @Substitute
        private static boolean isEnabled() {
            return notExpanding.get() == 0;
        }

        @Substitute
        public static <T> T withoutExpansion(Supplier<T> supplier) {
            if (Target_Expressions.isEnabled()) {
                notExpanding.set(1);
                try {
                    T t = supplier.get();
                    return t;
                }
                finally {
                    notExpanding.set(0);
                }
            }
            return supplier.get();
        }
    }

    @TargetClass(value=ConfigProviderResolver.class)
    static final class Target_ConfigurationProviderResolver {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        private static volatile ConfigProviderResolver instance;

        Target_ConfigurationProviderResolver() {
        }
    }
}

