/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public final class Slf4jLogger
extends MarkerIgnoringBase
implements Serializable,
LocationAwareLogger {
    private final Logger logger;
    private static final String LOGGER_CLASS_NAME = Slf4jLogger.class.getName();
    private static final long serialVersionUID = -8422185592693034532L;
    private static final int ALT_ERROR_INT = Level.ERROR.intValue();
    private static final int ALT_WARN_INT = Level.WARN.intValue();
    private static final int ALT_INFO_INT = Level.INFO.intValue();
    private static final int ALT_DEBUG_INT = Level.DEBUG.intValue();
    private static final int ALT_TRACE_INT = Level.TRACE.intValue();

    public Slf4jLogger(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void log(Marker marker, String fqcn, int levelVal, String fmt, Object[] argArray, Throwable t) {
        Level level;
        String message = MessageFormatter.arrayFormat(fmt, argArray).getMessage();
        switch (levelVal) {
            case 0: {
                level = Level.TRACE;
                break;
            }
            case 10: {
                level = Level.DEBUG;
                break;
            }
            case 20: {
                level = Level.INFO;
                break;
            }
            case 30: {
                level = Level.WARN;
                break;
            }
            case 40: {
                level = Level.ERROR;
                break;
            }
            default: {
                level = Level.DEBUG;
            }
        }
        if (this.logger.isLoggable(level)) {
            this.log((java.util.logging.Level)level, fqcn, message, t, argArray);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.TRACE);
    }

    @Override
    public void trace(String msg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.TRACE, msg, null);
    }

    @Override
    public void trace(String format, Object arg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log((java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log((java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log((java.util.logging.Level)Level.TRACE, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.TRACE, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.DEBUG);
    }

    @Override
    public void debug(String msg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.DEBUG, msg, null);
    }

    @Override
    public void debug(String format, Object arg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log((java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log((java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log((java.util.logging.Level)Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.DEBUG, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.INFO, msg, null);
    }

    @Override
    public void info(String format, Object arg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log((java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log((java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log((java.util.logging.Level)Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARN);
    }

    @Override
    public void warn(String msg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.WARN, msg, null);
    }

    @Override
    public void warn(String format, Object arg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log((java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log((java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log((java.util.logging.Level)Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.WARN, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.ERROR);
    }

    @Override
    public void error(String msg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.ERROR, msg, null);
    }

    @Override
    public void error(String format, Object arg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg);
        this.log((java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.format(format, arg1, arg2);
        this.log((java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
        this.log((java.util.logging.Level)Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable(), arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.log(Level.ERROR, msg, t);
    }

    @Override
    protected Slf4jLogger readResolve() throws ObjectStreamException {
        return this;
    }

    private void log(java.util.logging.Level level, String message, Throwable t) {
        ExtLogRecord rec = new ExtLogRecord(level, message, LOGGER_CLASS_NAME);
        rec.setThrown(t);
        this.logger.logRaw(rec);
    }

    private void log(java.util.logging.Level level, String message, Throwable t, Object ... params) {
        this.log(level, LOGGER_CLASS_NAME, message, t, params);
    }

    private void log(java.util.logging.Level level, String fqcn, String message, Throwable t, Object[] params) {
        ExtLogRecord rec = new ExtLogRecord(level, message, ExtLogRecord.FormatStyle.NO_FORMAT, fqcn);
        rec.setThrown(t);
        rec.setParameters(params);
        this.logger.logRaw(rec);
    }
}

