/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.endpoint;

import java.util.Map;
import org.kie.hacep.core.GlobalStatus;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Endpoints {
    @GetMapping(value={"/env/all"})
    public ResponseEntity<String> all() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)sb.toString());
    }

    @GetMapping(value={"/readiness"})
    public ResponseEntity<Void> getReadiness() {
        if (GlobalStatus.nodeReady) {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).build();
    }

    @GetMapping(value={"/liveness"})
    public ResponseEntity<Void> getLiveness() {
        if (GlobalStatus.nodeLive) {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).build();
    }
}

