/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core;

import java.util.Arrays;
import org.kie.hacep.Config;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.core.CoreKube;
import org.kie.hacep.core.GlobalStatus;
import org.kie.hacep.core.infra.consumer.ConsumerController;
import org.kie.hacep.core.infra.election.LeaderElection;
import org.kie.remote.impl.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger logger = LoggerFactory.getLogger(Bootstrap.class);
    private static Producer eventProducer;
    private static ConsumerController consumerController;
    private static CoreKube coreKube;

    public static void startEngine(EnvConfig envConfig) {
        coreKube = new CoreKube(envConfig.getNamespace(), null);
        eventProducer = Bootstrap.startProducer(envConfig);
        Bootstrap.startConsumers(envConfig, eventProducer);
        if (!envConfig.isUnderTest()) {
            Bootstrap.leaderElection();
        }
        GlobalStatus.nodeReady = true;
        logger.info("CONFIGURE on start engine:{}", (Object)envConfig);
    }

    public static void stopEngine() {
        logger.info("Stop engine");
        LeaderElection leadership = coreKube.getLeaderElection();
        try {
            leadership.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (consumerController != null) {
            consumerController.stop();
        }
        if (eventProducer != null) {
            eventProducer.stop();
        }
        eventProducer = null;
        consumerController = null;
    }

    public static ConsumerController getConsumerController() {
        return consumerController;
    }

    private static void leaderElection() {
        LeaderElection leadership = coreKube.getLeaderElection();
        coreKube.getLeaderElection().addCallbacks(Arrays.asList(consumerController.getCallback()));
        try {
            leadership.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static Producer startProducer(EnvConfig envConfig) {
        Producer producer = Producer.get((boolean)envConfig.isLocal());
        producer.start(Config.getProducerConfig("EventProducer"));
        return producer;
    }

    private static void startConsumers(EnvConfig envConfig, Producer producer) {
        consumerController = new ConsumerController(envConfig, producer);
        consumerController.start();
    }
}

