/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra;

import java.time.LocalDateTime;
import org.kie.api.runtime.KieSession;
import org.kie.hacep.consumer.FactHandlesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotInfos {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotInfos.class);
    private KieSession kieSession;
    private FactHandlesManager fhManager;
    private String keyDuringSnaphot;
    private long offsetDuringSnapshot;
    private LocalDateTime time;

    public SnapshotInfos(KieSession kieSession, FactHandlesManager fhManager, String keyDuringSnaphot, long offsetDuringSnapshot, LocalDateTime time) {
        this.kieSession = kieSession;
        this.fhManager = fhManager.initFromKieSession(kieSession);
        this.keyDuringSnaphot = keyDuringSnaphot;
        this.offsetDuringSnapshot = offsetDuringSnapshot;
        this.time = time;
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }

    public FactHandlesManager getFhManager() {
        return this.fhManager;
    }

    public String getKeyDuringSnaphot() {
        return this.keyDuringSnaphot;
    }

    public long getOffsetDuringSnapshot() {
        return this.offsetDuringSnapshot;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SnapshotInfos{");
        sb.append("kieSession=").append(this.kieSession);
        sb.append(", keyDuringSnaphot='").append(this.keyDuringSnaphot).append('\'');
        sb.append(", offsetDuringSnapshot=").append(this.offsetDuringSnapshot);
        sb.append(", time=").append(this.time);
        sb.append('}');
        return sb.toString();
    }
}

