/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.consumer;

import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.DroolsConsumerHandler;
import org.kie.hacep.core.infra.consumer.ConsumerThread;
import org.kie.hacep.core.infra.consumer.EventConsumer;
import org.kie.hacep.core.infra.consumer.InfraCallback;
import org.kie.hacep.core.infra.election.LeadershipCallback;
import org.kie.remote.impl.producer.Producer;

public class ConsumerController {
    private EventConsumer consumer;
    private InfraCallback callback = new InfraCallback();
    private Thread thread;
    private EnvConfig envConfig;

    public ConsumerController(EnvConfig envConfig, Producer producer) {
        this.consumer = EventConsumer.get(envConfig);
        this.callback.setConsumer(this.consumer);
        this.consumer.initConsumer(new DroolsConsumerHandler(producer, envConfig));
        this.envConfig = envConfig;
    }

    public void start() {
        this.consumeEvents();
    }

    public void stop() {
        this.consumer.stop();
        this.stopConsumeEvents();
    }

    public EventConsumer getConsumer() {
        return this.consumer;
    }

    public LeadershipCallback getCallback() {
        return this.callback;
    }

    private void consumeEvents() {
        this.thread = new Thread(new ConsumerThread(this.envConfig.getPollTimeout(), this));
        this.thread.start();
    }

    private void stopConsumeEvents() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

