/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.kie.hacep.Config;
import org.kie.hacep.util.Printer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrinterLogImpl
implements Printer {
    private static Logger logger = LoggerFactory.getLogger(PrinterLogImpl.class);

    @Override
    public void prettyPrinter(String caller, ConsumerRecord consumerRecord, boolean processed) {
        if (consumerRecord != null) {
            logger.info("Caller:{} - Processed:{} - Topic: {} - Partition: {} - Offset: {} - Value: {}\n", new Object[]{caller, processed, consumerRecord.topic(), consumerRecord.partition(), consumerRecord.offset(), !(consumerRecord.value() instanceof byte[]) ? consumerRecord.value() : "bytes[]"});
        }
    }

    public Map<TopicPartition, Long> getOffsets(String topic) {
        KafkaConsumer consumer = new KafkaConsumer(Config.getConsumerConfig("OffsetConsumer"));
        consumer.subscribe(Arrays.asList(topic));
        List infos = consumer.partitionsFor(topic);
        ArrayList<TopicPartition> tps = new ArrayList<TopicPartition>();
        for (PartitionInfo info : infos) {
            tps.add(new TopicPartition(topic, info.partition()));
        }
        Map offsets = consumer.endOffsets(tps);
        consumer.close();
        return offsets;
    }
}

