/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.kie.hacep.PollUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    public static final String BOOTSTRAP_SERVERS_KEY = "bootstrap.servers";
    public static final String BATCH_SIZE_KEY = "batch.size";
    public static final String ENABLE_AUTOCOMMIT_KEY = "enable.auto.commit";
    public static final String MAX_POLL_INTERVALS_MS_KEY = "max.poll.interval.ms";
    public static final String METADATA_MAX_AGE_MS_KEY = "metadata.max.age.ms";
    public static final String DEFAULT_KAFKA_PORT = "9092";
    public static final String NAMESPACE = "namespace";
    public static final String DEFAULT_CONTROL_TOPIC = "control";
    public static final String DEFAULT_SNAPSHOT_TOPIC = "snapshot";
    public static final String ITERATION_BETWEEN_SNAPSHOT = "iteration.between.snapshot";
    public static final int DEFAULT_ITERATION_BETWEEN_SNAPSHOT = 10;
    public static final String DEFAULT_PRINTER_TYPE = "printer.type";
    public static final String MAX_SNAPSHOT_AGE = "max.snapshot.age";
    public static final String DEFAULT_MAX_SNAPSHOT_AGE_SEC = "600";
    public static final String MY_CLUSTER_KAFKA_BOOTSTRAP_SERVICE_HOST = "MY_CLUSTER_KAFKA_BOOTSTRAP_SERVICE_HOST";
    public static final String BROKER_URL = System.getenv("MY_CLUSTER_KAFKA_BOOTSTRAP_SERVICE_HOST");
    public static final int DEFAULT_POLL_TIMEOUT = 1000;
    public static final int DEFAULT_POLL_SNAPSHOT_TIMEOUT = 1;
    public static final String POLL_TIMEOUT = "poll.timeout";
    public static final String POLL_TIMEOUT_SNAPSHOT = "poll.timeout.snapshot";
    public static final String POLL_TIMEOUT_UNIT = "poll.timeout.unit";
    public static final String POLL_TIMEOUT_UNIT_SNAPSHOT = "poll.timeout.unit.snapshot";
    public static final PollUnit POLL_TIMEOUT_DEFAULT_UNIT = PollUnit.MILLISECOND;
    public static final PollUnit POLL_TIMEOUT_SNAPSHOT_DEFAULT_UNIT = PollUnit.SECOND;
    public static final String SKIP_ON_DEMAND_SNAPSHOT = "skip.ondemandsnapshoot";
    public static final String TEST = Boolean.FALSE.toString();
    public static final String UNDER_TEST = "undertest";
    public static final String MAX_SNAPSHOT_REQUEST_ATTEMPTS = "max.snapshot.request.attempts";
    public static final String DEFAULT_MAX_SNAPSHOT_REQUEST_ATTEMPTS = "10";
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static Properties config;
    private static Properties consumerConf;
    private static Properties producerConf;
    private static Properties snapshotConsumerConf;
    private static Properties snapshotProducerConf;
    private static final String CONSUMER_CONF = "consumer.properties";
    private static final String PRODUCER_CONF = "producer.properties";
    private static final String CONF = "infra.properties";
    private static final String SNAPSHOT_CONSUMER_CONF = "snapshot_consumer.properties";
    private static final String SNAPSHOT_PRODUCER_CONF = "snapshot_producer.properties";

    public static String getBootStrapServers() {
        StringBuilder sb = new StringBuilder();
        sb.append(BROKER_URL).append(":").append(DEFAULT_KAFKA_PORT);
        return sb.toString();
    }

    public static Properties getDefaultConfig() {
        return Config.getDefaultConfigFromProps(CONF);
    }

    public static Properties getConsumerConfig(String caller) {
        if (consumerConf == null) {
            consumerConf = Config.getDefaultConfigFromProps(CONSUMER_CONF);
        }
        Config.logConfig(caller, consumerConf);
        return consumerConf;
    }

    public static Properties getProducerConfig(String caller) {
        if (producerConf == null) {
            producerConf = Config.getDefaultConfigFromProps(PRODUCER_CONF);
        }
        Config.logConfig(caller, producerConf);
        return producerConf;
    }

    public static Properties getSnapshotConsumerConfig() {
        if (snapshotConsumerConf == null) {
            snapshotConsumerConf = Config.getDefaultConfigFromProps(SNAPSHOT_CONSUMER_CONF);
        }
        Config.logConfig("SnapshotConsumer", snapshotConsumerConf);
        return snapshotConsumerConf;
    }

    public static Properties getSnapshotProducerConfig() {
        if (snapshotProducerConf == null) {
            snapshotProducerConf = Config.getDefaultConfigFromProps(SNAPSHOT_PRODUCER_CONF);
        }
        Config.logConfig("SnapshotProducer", snapshotProducerConf);
        return snapshotProducerConf;
    }

    public static Properties getStatic() {
        if (config == null) {
            config = new Properties();
            config.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            config.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            config.put(BOOTSTRAP_SERVERS_KEY, Config.getBootStrapServers());
            config.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            config.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            config.put(MAX_POLL_INTERVALS_MS_KEY, "10000");
            config.put(BATCH_SIZE_KEY, "16384");
            config.put(ENABLE_AUTOCOMMIT_KEY, "false");
            config.put(METADATA_MAX_AGE_MS_KEY, "10000");
            config.put(ITERATION_BETWEEN_SNAPSHOT, DEFAULT_MAX_SNAPSHOT_REQUEST_ATTEMPTS);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getDefaultConfigFromProps(String fileName) {
        Properties config = new Properties();
        InputStream in = null;
        try {
            in = Config.class.getClassLoader().getResourceAsStream(fileName);
        }
        catch (Exception ioe) {
        }
        finally {
            try {
                config.load(in);
                in.close();
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        if (config.get(BOOTSTRAP_SERVERS_KEY) == null) {
            config.put(BOOTSTRAP_SERVERS_KEY, Config.getBootStrapServers());
        }
        return config;
    }

    private static void logConfig(String subject, Properties producerProperties) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append(subject);
            sb.append("\n{\n");
            for (Map.Entry<Object, Object> entry : producerProperties.entrySet()) {
                sb.append(" ").append(entry.getKey().toString()).append(":").append(entry.getValue()).append("  \n");
            }
            sb.append("\n}\n");
            logger.debug(sb.toString());
        }
    }
}

