/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.time.Duration;
import java.util.Optional;
import org.kie.hacep.Config;
import org.kie.hacep.PollUnit;
import org.kie.hacep.util.PrinterLogImpl;

public final class EnvConfig {
    private String namespace;
    private String eventsTopicName;
    private String controlTopicName;
    private String snapshotTopicName;
    private String kieSessionInfosTopicName;
    private String printerType;
    private int iterationBetweenSnapshot = 10;
    private int pollTimeout = 1000;
    private int pollSnapshotTimeout = 1;
    private int maxSnapshotRequestAttempts = 10;
    private boolean skipOnDemanSnapshot;
    private long maxSnapshotAge;
    private boolean test;
    private boolean local;
    private PollUnit pollUnit;
    private PollUnit pollUnitSnapshot;
    private Duration pollDuration;
    private Duration pollSnapshotDuration;
    private static final String sec = "sec";
    private static final String millisec = "millisec";

    private EnvConfig() {
    }

    public static EnvConfig getDefaultEnvConfig() {
        return EnvConfig.anEnvConfig().withNamespace(Optional.ofNullable(System.getenv("namespace")).orElse("default")).withControlTopicName(Optional.ofNullable(System.getenv("control")).orElse("control")).withEventsTopicName(Optional.ofNullable(System.getenv("events")).orElse("events")).withSnapshotTopicName(Optional.ofNullable(System.getenv("snapshot")).orElse("snapshot")).withKieSessionInfosTopicName(Optional.ofNullable(System.getenv("kiesessioninfos")).orElse("kiesessioninfos")).withPrinterType(Optional.ofNullable(System.getenv("printer.type")).orElse(PrinterLogImpl.class.getName())).withPollTimeout(Optional.ofNullable(System.getenv("poll.timeout")).orElse(String.valueOf(1000))).withPollTimeUnit(Optional.ofNullable(System.getenv("poll.timeout.unit")).orElse(millisec)).withPollSnapshotTimeout(Optional.ofNullable(System.getenv("poll.timeout.snapshot")).orElse(String.valueOf(1))).withPollSnapshotTimeUnit(Optional.ofNullable(System.getenv("poll.timeout.unit.snapshot")).orElse(sec)).skipOnDemandSnapshot(Optional.ofNullable(System.getenv("skip.ondemandsnapshoot")).orElse(Boolean.FALSE.toString())).withIterationBetweenSnapshot(Optional.ofNullable(System.getenv("iteration.between.snapshot")).orElse(String.valueOf(10))).withMaxSnapshotAgeSeconds(Optional.ofNullable(System.getenv("max.snapshot.age")).orElse("600")).withMaxSnapshotRequestAttempts(Optional.ofNullable(System.getenv("max.snapshot.request.attempts")).orElse("10")).underTest(Optional.ofNullable(System.getenv("undertest")).orElse(Config.TEST));
    }

    public static EnvConfig anEnvConfig() {
        return new EnvConfig();
    }

    public EnvConfig withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public EnvConfig withEventsTopicName(String eventsTopicName) {
        this.eventsTopicName = eventsTopicName;
        return this;
    }

    public EnvConfig withControlTopicName(String controlTopicName) {
        this.controlTopicName = controlTopicName;
        return this;
    }

    public EnvConfig withSnapshotTopicName(String snapshotTopicName) {
        this.snapshotTopicName = snapshotTopicName;
        return this;
    }

    public EnvConfig withKieSessionInfosTopicName(String kieSessionInfosTopicName) {
        this.kieSessionInfosTopicName = kieSessionInfosTopicName;
        return this;
    }

    public EnvConfig withPrinterType(String printerType) {
        this.printerType = printerType;
        return this;
    }

    public EnvConfig withPollTimeout(String pollTimeout) {
        this.pollTimeout = Integer.valueOf(pollTimeout);
        return this;
    }

    public EnvConfig withPollSnapshotTimeout(String pollSnapshotTimeout) {
        this.pollSnapshotTimeout = Integer.valueOf(pollSnapshotTimeout);
        return this;
    }

    public EnvConfig withIterationBetweenSnapshot(String iterationBetweenSnapshot) {
        this.iterationBetweenSnapshot = Integer.valueOf(iterationBetweenSnapshot);
        return this;
    }

    public EnvConfig underTest(String underTest) {
        return this.underTest(Boolean.valueOf(underTest));
    }

    public EnvConfig underTest(boolean underTest) {
        this.test = underTest;
        return this;
    }

    public EnvConfig local(boolean local) {
        this.local = local;
        return this;
    }

    public EnvConfig skipOnDemandSnapshot(String skipOnDemandSnapshoot) {
        this.skipOnDemanSnapshot = Boolean.valueOf(skipOnDemandSnapshoot);
        return this;
    }

    public EnvConfig withMaxSnapshotAgeSeconds(String maxSnapshotAge) {
        this.maxSnapshotAge = Long.valueOf(maxSnapshotAge);
        return this;
    }

    public EnvConfig withMaxSnapshotRequestAttempts(String maxSnapshotRequestAttempts) {
        this.maxSnapshotRequestAttempts = Integer.parseInt(maxSnapshotRequestAttempts);
        return this;
    }

    public EnvConfig withPollTimeUnit(String pollTimeUnit) {
        switch (pollTimeUnit) {
            case "millisec": {
                this.pollUnit = PollUnit.MILLISECOND;
                this.pollDuration = Duration.ofMillis(this.pollTimeout);
                break;
            }
            case "sec": {
                this.pollUnit = PollUnit.SECOND;
                this.pollDuration = Duration.ofSeconds(this.pollTimeout);
                break;
            }
            default: {
                throw new RuntimeException("No pollTimeUnit provided");
            }
        }
        return this;
    }

    public EnvConfig withPollSnapshotTimeUnit(String pollSnapshotTimeUnit) {
        switch (pollSnapshotTimeUnit) {
            case "millisec": {
                this.pollUnitSnapshot = PollUnit.MILLISECOND;
                this.pollSnapshotDuration = Duration.ofMillis(this.pollSnapshotTimeout);
                break;
            }
            case "sec": {
                this.pollUnitSnapshot = PollUnit.SECOND;
                this.pollSnapshotDuration = Duration.ofSeconds(this.pollSnapshotTimeout);
                break;
            }
            default: {
                throw new RuntimeException("No pollSnapshotTimeUnit provided");
            }
        }
        return this;
    }

    public EnvConfig clone() {
        EnvConfig envConfig = new EnvConfig();
        envConfig.eventsTopicName = this.eventsTopicName;
        envConfig.namespace = this.namespace;
        envConfig.controlTopicName = this.controlTopicName;
        envConfig.snapshotTopicName = this.snapshotTopicName;
        envConfig.kieSessionInfosTopicName = this.kieSessionInfosTopicName;
        envConfig.printerType = this.printerType;
        envConfig.test = this.test;
        envConfig.local = this.local;
        envConfig.pollTimeout = this.pollTimeout;
        envConfig.pollSnapshotTimeout = this.pollSnapshotTimeout;
        envConfig.iterationBetweenSnapshot = this.iterationBetweenSnapshot;
        envConfig.skipOnDemanSnapshot = this.skipOnDemanSnapshot;
        envConfig.maxSnapshotAge = this.maxSnapshotAge;
        envConfig.maxSnapshotRequestAttempts = this.maxSnapshotRequestAttempts;
        envConfig.pollUnit = this.pollUnit;
        envConfig.pollUnitSnapshot = this.pollUnitSnapshot;
        return envConfig;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEventsTopicName() {
        return this.eventsTopicName;
    }

    public String getControlTopicName() {
        return this.controlTopicName;
    }

    public String getSnapshotTopicName() {
        return this.snapshotTopicName;
    }

    public String getKieSessionInfosTopicName() {
        return this.kieSessionInfosTopicName;
    }

    public String getPrinterType() {
        return this.printerType;
    }

    public boolean isUnderTest() {
        return this.test;
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }

    public int getPollSnapshotTimeout() {
        return this.pollSnapshotTimeout;
    }

    public int getIterationBetweenSnapshot() {
        return this.iterationBetweenSnapshot;
    }

    public boolean isSkipOnDemanSnapshot() {
        return this.skipOnDemanSnapshot;
    }

    public long getMaxSnapshotAge() {
        return this.maxSnapshotAge;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getMaxSnapshotRequestAttempts() {
        return this.maxSnapshotRequestAttempts;
    }

    public PollUnit getPollUnit() {
        return this.pollUnit;
    }

    public PollUnit getPollSnapshotUnit() {
        return this.pollUnitSnapshot;
    }

    public Duration getPollDuration() {
        return this.pollDuration;
    }

    public Duration getPollSnapshotDuration() {
        return this.pollSnapshotDuration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EnvConfig{");
        sb.append("namespace='").append(this.namespace).append('\'');
        sb.append(", eventsTopicName='").append(this.eventsTopicName).append('\'');
        sb.append(", controlTopicName='").append(this.controlTopicName).append('\'');
        sb.append(", snapshotTopicName='").append(this.snapshotTopicName).append('\'');
        sb.append(", kieSessionInfosTopicName='").append(this.kieSessionInfosTopicName).append('\'');
        sb.append(", printerType='").append(this.printerType).append('\'');
        sb.append(", pollTimeUnit='").append((Object)this.pollUnit).append('\'');
        sb.append(", pollTimeout='").append(this.pollTimeout).append('\'');
        sb.append(", pollDuration='").append(this.pollDuration).append('\'');
        sb.append(", pollSnapshotUnit='").append((Object)this.pollUnitSnapshot).append('\'');
        sb.append(", pollSnapshotDuration='").append(this.pollSnapshotDuration).append('\'');
        sb.append(", pollSnapshotTimeout='").append(this.pollSnapshotTimeout).append('\'');
        sb.append(", iterationBetweenSnapshot='").append(this.iterationBetweenSnapshot).append('\'');
        sb.append(", skipOnDemanSnapshot='").append(this.skipOnDemanSnapshot).append('\'');
        sb.append(", maxSnapshotAge='").append(this.maxSnapshotAge).append('\'');
        sb.append(", maxSnapshotRequestAttempts='").append(this.maxSnapshotRequestAttempts).append('\'');
        sb.append(", underTest='").append(this.test).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

