/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.consumer;

import java.util.Queue;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.CommandHandler;
import org.kie.hacep.core.GlobalStatus;
import org.kie.hacep.core.KieSessionContext;
import org.kie.hacep.core.infra.DefaultSessionSnapShooter;
import org.kie.hacep.core.infra.SnapshotInfos;
import org.kie.hacep.core.infra.consumer.ConsumerHandler;
import org.kie.hacep.core.infra.consumer.ItemToProcess;
import org.kie.hacep.core.infra.election.State;
import org.kie.hacep.core.infra.utils.SnapshotOnDemandUtils;
import org.kie.hacep.message.ControlMessage;
import org.kie.hacep.util.PrinterUtil;
import org.kie.remote.DroolsExecutor;
import org.kie.remote.command.RemoteCommand;
import org.kie.remote.command.VisitableCommand;
import org.kie.remote.command.VisitorCommand;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.message.Message;
import org.kie.remote.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsConsumerHandler
implements ConsumerHandler {
    private static final Logger logger = LoggerFactory.getLogger(DroolsConsumerHandler.class);
    private Logger loggerForTest;
    private Producer producer;
    private DefaultSessionSnapShooter snapshooter;
    private EnvConfig config;
    private KieSessionContext kieSessionContext;
    private CommandHandler commandHandler;
    private SnapshotInfos infos;
    private boolean shutdown;

    public DroolsConsumerHandler(Producer producer, EnvConfig envConfig) {
        this.config = envConfig;
        this.snapshooter = new DefaultSessionSnapShooter(this.config);
        this.initializeKieSessionFromSnapshot(this.config);
        this.producer = producer;
        this.commandHandler = new CommandHandler(this.kieSessionContext, this.config, producer, this.snapshooter);
        if (this.config.isUnderTest()) {
            this.loggerForTest = PrinterUtil.getKafkaLoggerForTest(envConfig);
        }
    }

    private void initializeKieSessionFromSnapshot(EnvConfig config) {
        if (config.isSkipOnDemanSnapshot()) {
            this.infos = this.snapshooter.deserialize();
            this.kieSessionContext = this.createSessionHolder(this.infos);
        } else {
            this.kieSessionContext = new KieSessionContext();
            this.createClasspathSession(this.kieSessionContext);
        }
    }

    public boolean initializeKieSessionFromSnapshotOnDemand(EnvConfig config) {
        if (!config.isSkipOnDemanSnapshot()) {
            this.infos = SnapshotOnDemandUtils.askASnapshotOnDemand(config, this.snapshooter);
            this.kieSessionContext = this.createSessionHolder(this.infos);
            return true;
        }
        return false;
    }

    public DefaultSessionSnapShooter getSnapshooter() {
        return this.snapshooter;
    }

    @Override
    public void process(ItemToProcess item, State state) {
        RemoteCommand command = (RemoteCommand)SerializationUtil.deserialize((byte[])((byte[])item.getObject()));
        this.process(command, state);
    }

    @Override
    public void process(RemoteCommand command, State state) {
        if (this.config.isUnderTest()) {
            this.loggerForTest.warn("DroolsConsumerHandler.process Remote command on process:{} state:{}", (Object)command, (Object)state);
        }
        if (state.equals((Object)State.LEADER)) {
            this.processCommand(command, state);
            Queue sideEffectsResults = DroolsExecutor.getInstance().getAndReset();
            if (this.config.isUnderTest()) {
                this.loggerForTest.warn("DroolsConsumerHandler.process sideEffects:{}", (Object)sideEffectsResults);
            }
            ControlMessage newControlMessage = new ControlMessage(command.getId(), sideEffectsResults);
            if (this.config.isUnderTest()) {
                this.loggerForTest.warn("DroolsConsumerHandler.process new ControlMessage sent to control topic:{}", (Object)newControlMessage);
            }
            this.producer.produceSync(this.config.getControlTopicName(), command.getId(), (Message)newControlMessage);
            if (this.config.isUnderTest()) {
                this.loggerForTest.warn("sideEffectOnLeader:{}", (Object)sideEffectsResults);
            }
        } else {
            this.processCommand(command, state);
        }
    }

    public void processSideEffectsOnReplica(Queue<Object> newSideEffects) {
        DroolsExecutor.getInstance().appendSideEffects(newSideEffects);
        if (this.config.isUnderTest()) {
            this.loggerForTest.warn("sideEffectOnReplica:{}", newSideEffects);
        }
    }

    @Override
    public void processWithSnapshot(ItemToProcess item, State currentState) {
        if (logger.isInfoEnabled()) {
            logger.info("SNAPSHOT");
        }
        this.process(item, currentState);
        if (!this.shutdown) {
            this.snapshooter.serialize(this.kieSessionContext, item.getKey(), item.getOffset());
        }
    }

    @Override
    public void stop() {
        this.shutdown = true;
        if (this.kieSessionContext != null) {
            this.kieSessionContext.getKieSession().dispose();
        }
    }

    private void processCommand(RemoteCommand command, State state) {
        boolean execute;
        boolean bl = execute = state.equals((Object)State.LEADER) || command.isPermittedForReplicas();
        if (execute) {
            VisitableCommand visitable = (VisitableCommand)command;
            try {
                visitable.accept((VisitorCommand)this.commandHandler);
            }
            catch (Throwable e) {
                GlobalStatus.nodeLive = false;
                throw e;
            }
        }
    }

    private KieSessionContext createSessionHolder(SnapshotInfos infos) {
        KieSessionContext kieSessionContext = new KieSessionContext();
        if (infos != null) {
            if (logger.isInfoEnabled()) {
                logger.info("start consumer with:{}", (Object)infos);
            }
            this.initSessionHolder(infos, kieSessionContext);
        } else {
            this.createClasspathSession(kieSessionContext);
        }
        return kieSessionContext;
    }

    private void createClasspathSession(KieSessionContext kieSessionContext) {
        KieServices srv = KieServices.get();
        if (srv != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Creating new Kie Session");
            }
            KieContainer kieContainer = KieServices.get().newKieClasspathContainer();
            kieSessionContext.init(kieContainer.newKieSession());
        } else {
            logger.error("KieService is null");
        }
    }

    private void initSessionHolder(SnapshotInfos infos, KieSessionContext kieSessionContext) {
        if (infos.getKieSession() == null) {
            KieContainer kieContainer = KieServices.get().newKieClasspathContainer();
            kieSessionContext.init(kieContainer.newKieSession());
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("Applying snapshot");
            }
            kieSessionContext.initFromSnapshot(infos);
        }
    }
}

