/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core;

import java.util.concurrent.TimeUnit;
import org.kie.api.runtime.KieSession;
import org.kie.api.time.SessionClock;
import org.kie.api.time.SessionPseudoClock;
import org.kie.hacep.consumer.FactHandlesManager;
import org.kie.hacep.core.infra.SnapshotInfos;

public class KieSessionContext {
    private KieSession kieSession;
    private SessionPseudoClock clock;
    private FactHandlesManager fhManager;

    public KieSession getKieSession() {
        return this.kieSession;
    }

    public void initFromSnapshot(SnapshotInfos infos) {
        this.setKieSession(infos.getKieSession());
        this.fhManager = infos.getFhManager();
    }

    public void init(KieSession newKiession) {
        this.setKieSession(newKiession);
        this.fhManager = new FactHandlesManager(newKiession);
    }

    private void setKieSession(KieSession kieSession) {
        this.kieSession = kieSession;
        SessionClock clock = kieSession.getSessionClock();
        if (clock instanceof SessionPseudoClock) {
            this.clock = (SessionPseudoClock)clock;
        }
    }

    public FactHandlesManager getFhManager() {
        return this.fhManager;
    }

    public void setClockAt(long time) {
        if (this.clock == null) {
            throw new IllegalStateException("Drools HACEP is not running with a pseudo-clock");
        }
        this.clock.advanceTime(time - this.clock.getCurrentTime(), TimeUnit.MILLISECONDS);
    }
}

