/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra.utils;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.kie.hacep.Config;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.message.ControlMessage;
import org.kie.hacep.message.FactCountMessage;
import org.kie.remote.RemoteFactHandle;
import org.kie.remote.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerUtils {
    private static Logger logger = LoggerFactory.getLogger(ConsumerUtils.class);

    public static ControlMessage getLastEvent(String topic, Integer pollTimeout) {
        return ConsumerUtils.getLastEvent(topic, Config.getConsumerConfig("LastEventConsumer"), pollTimeout);
    }

    public Map<TopicPartition, Long> getOffsets(String topic) {
        KafkaConsumer consumer = new KafkaConsumer(Config.getConsumerConfig("OffsetConsumer"));
        consumer.subscribe(Arrays.asList(topic));
        List infos = consumer.partitionsFor(topic);
        ArrayList<TopicPartition> tps = new ArrayList<TopicPartition>();
        for (PartitionInfo info : infos) {
            tps.add(new TopicPartition(topic, info.partition()));
        }
        Map offsets = consumer.endOffsets(tps);
        consumer.close();
        return offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static ControlMessage getLastEvent(String topic, Properties properties, Integer pollTimeout) {
        void var9_12;
        KafkaConsumer consumer = new KafkaConsumer(properties);
        List infos = consumer.partitionsFor(topic);
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        if (infos != null) {
            for (PartitionInfo partition : infos) {
                partitions.add(new TopicPartition(topic, partition.partition()));
            }
        }
        consumer.assign(partitions);
        Map offsets = consumer.endOffsets(partitions);
        Long lastOffset = 0L;
        for (Map.Entry entry : offsets.entrySet()) {
            lastOffset = (Long)entry.getValue();
        }
        if (lastOffset == 0L) {
            lastOffset = 1L;
        }
        Set assignments = consumer.assignment();
        for (TopicPartition part : assignments) {
            consumer.seek(part, lastOffset - 1L);
        }
        ControlMessage controlMessage = new ControlMessage();
        try {
            ConsumerRecords records = consumer.poll(Duration.of(pollTimeout.intValue(), ChronoUnit.MILLIS));
            for (Object item : records) {
                ConsumerRecord record = (ConsumerRecord)item;
                ControlMessage controlMessage2 = (ControlMessage)SerializationUtil.deserialize((byte[])((byte[])record.value()));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            consumer.close();
        }
        return var9_12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static FactCountMessage getFactCount(RemoteFactHandle factHandle, EnvConfig config, Properties properties) {
        void var9_13;
        KafkaConsumer consumer = new KafkaConsumer(properties);
        List infos = consumer.partitionsFor(config.getKieSessionInfosTopicName());
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        if (infos != null) {
            for (PartitionInfo partition : infos) {
                partitions.add(new TopicPartition(config.getKieSessionInfosTopicName(), partition.partition()));
            }
        }
        consumer.assign(partitions);
        Map offsets = consumer.endOffsets(partitions);
        Long lastOffset = 0L;
        for (Map.Entry entry : offsets.entrySet()) {
            lastOffset = (Long)entry.getValue();
        }
        if (lastOffset == 0L) {
            lastOffset = 1L;
        }
        Set assignments = consumer.assignment();
        for (TopicPartition part : assignments) {
            consumer.seek(part, lastOffset - 1L);
        }
        FactCountMessage factCountMessage = new FactCountMessage();
        try {
            ConsumerRecords records = consumer.poll(Duration.of(1000L, ChronoUnit.MILLIS));
            for (Object item : records) {
                ConsumerRecord record = (ConsumerRecord)item;
                if (!((String)record.key()).equals(factHandle.getId())) continue;
                FactCountMessage factCountMessage2 = (FactCountMessage)SerializationUtil.deserialize((byte[])((byte[])record.value()));
                break;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            consumer.close();
        }
        return var9_13;
    }
}

