/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.util;

import org.kie.hacep.EnvConfig;
import org.kie.hacep.util.Printer;
import org.kie.hacep.util.PrinterLogImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrinterUtil {
    private static final Logger logger = LoggerFactory.getLogger(PrinterUtil.class);

    public static Printer getPrinter(EnvConfig config) {
        Printer returnInstance;
        if (config.getPrinterType().equals(PrinterLogImpl.class.getName())) {
            return new PrinterLogImpl();
        }
        try {
            returnInstance = (Printer)Class.forName(config.getPrinterType()).newInstance();
        }
        catch (Exception ex) {
            logger.error("Printer:{} not found, using PrinterLog", (Object)ex.getMessage());
            return new PrinterLogImpl();
        }
        return returnInstance;
    }

    public static Logger getKafkaLoggerForTest(EnvConfig config) {
        if (config.isLocal()) {
            return logger;
        }
        if (config.isUnderTest() && !config.getPrinterType().equals(PrinterLogImpl.class.getName())) {
            return LoggerFactory.getLogger((String)"org.hacep");
        }
        return null;
    }
}

