/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kie.server.api.model.admin.MigrationReportInstance;

@Entity
@Table(name="migration_reports", indexes={@Index(columnList="migration_id")})
public class MigrationReport
extends PanacheEntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="migRepIdSeq")
    @SequenceGenerator(name="migRepIdSeq", sequenceName="MIG_REP_ID_SEQ")
    private Long id;
    @Column(name="migration_id")
    private Long migrationId;
    @Column(name="process_instance_id")
    private Long processInstanceId;
    @Column(name="start_date")
    private Instant startDate;
    @Column(name="end_date")
    private Instant endDate;
    @Column(name="success")
    private Boolean successful;
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="log")
    @Lob
    @CollectionTable(name="migration_report_logs", joinColumns={@JoinColumn(name="report_id")})
    private List<String> logs;

    public MigrationReport() {
    }

    public MigrationReport(Long migrationId, MigrationReportInstance reportInstance) {
        this.migrationId = migrationId;
        this.processInstanceId = reportInstance.getProcessInstanceId();
        if (reportInstance.getStartDate() != null) {
            this.startDate = reportInstance.getStartDate().toInstant();
        }
        if (reportInstance.getEndDate() != null) {
            this.endDate = reportInstance.getEndDate().toInstant();
        }
        this.successful = reportInstance.isSuccessful();
        this.logs = new ArrayList<String>(reportInstance.getLogs());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationReport)) {
            return false;
        }
        MigrationReport other = (MigrationReport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$migrationId = this.getMigrationId();
        Long other$migrationId = other.getMigrationId();
        if (this$migrationId == null ? other$migrationId != null : !((Object)this$migrationId).equals(other$migrationId)) {
            return false;
        }
        Long this$processInstanceId = this.getProcessInstanceId();
        Long other$processInstanceId = other.getProcessInstanceId();
        if (this$processInstanceId == null ? other$processInstanceId != null : !((Object)this$processInstanceId).equals(other$processInstanceId)) {
            return false;
        }
        Boolean this$successful = this.getSuccessful();
        Boolean other$successful = other.getSuccessful();
        if (this$successful == null ? other$successful != null : !((Object)this$successful).equals(other$successful)) {
            return false;
        }
        Instant this$startDate = this.getStartDate();
        Instant other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Instant this$endDate = this.getEndDate();
        Instant other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        List<String> this$logs = this.getLogs();
        List<String> other$logs = other.getLogs();
        return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigrationReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $migrationId = this.getMigrationId();
        result = result * 59 + ($migrationId == null ? 43 : ((Object)$migrationId).hashCode());
        Long $processInstanceId = this.getProcessInstanceId();
        result = result * 59 + ($processInstanceId == null ? 43 : ((Object)$processInstanceId).hashCode());
        Boolean $successful = this.getSuccessful();
        result = result * 59 + ($successful == null ? 43 : ((Object)$successful).hashCode());
        Instant $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Instant $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        List<String> $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        return result;
    }

    public String toString() {
        return "MigrationReport(id=" + this.getId() + ", migrationId=" + this.getMigrationId() + ", processInstanceId=" + this.getProcessInstanceId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", successful=" + this.getSuccessful() + ", logs=" + this.getLogs() + ")";
    }

    public Long getId() {
        return this.id;
    }

    public Long getMigrationId() {
        return this.migrationId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public Boolean getSuccessful() {
        return this.successful;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public MigrationReport setId(Long id) {
        this.id = id;
        return this;
    }

    public MigrationReport setMigrationId(Long migrationId) {
        this.migrationId = migrationId;
        return this;
    }

    public MigrationReport setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public MigrationReport setStartDate(Instant startDate) {
        this.startDate = startDate;
        return this;
    }

    public MigrationReport setEndDate(Instant endDate) {
        this.endDate = endDate;
        return this;
    }

    public MigrationReport setSuccessful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    public MigrationReport setLogs(List<String> logs) {
        this.logs = logs;
        return this;
    }
}

