/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api.buildplan;

import com.google.cloud.tools.jib.buildplan.UnixPathParser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RelativeUnixPath {
    private final List<String> pathComponents;

    public static RelativeUnixPath get(String relativePath) {
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Path starts with forward slash (/): " + relativePath);
        }
        return new RelativeUnixPath(UnixPathParser.parse(relativePath));
    }

    private RelativeUnixPath(List<String> pathComponents) {
        this.pathComponents = pathComponents;
    }

    List<String> getRelativePathComponents() {
        return new ArrayList<String>(this.pathComponents);
    }
}

