/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.executor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluatorFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLModelEvaluatorFinderImpl
implements PMMLModelEvaluatorFinder {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLModelEvaluatorFinderImpl.class.getName());
    private ServiceLoader<PMMLModelEvaluator> loader = ServiceLoader.load(PMMLModelEvaluator.class);

    @Override
    public List<PMMLModelEvaluator> getImplementations(boolean refresh) {
        logger.debug("getImplementations {}", (Object)refresh);
        ArrayList<PMMLModelEvaluator> toReturn = new ArrayList<PMMLModelEvaluator>();
        Iterator<PMMLModelEvaluator> providers = this.getProviders(refresh);
        providers.forEachRemaining(toReturn::add);
        logger.debug("toReturn {} {}", toReturn, (Object)toReturn.size());
        if (logger.isTraceEnabled()) {
            toReturn.forEach(provider -> logger.trace("{} : {}", (Object)provider.getPMMLModelType(), provider));
        }
        return toReturn;
    }

    private Iterator<PMMLModelEvaluator> getProviders(boolean refresh) {
        if (refresh) {
            this.loader.reload();
        }
        return this.loader.iterator();
    }
}

