/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.kie.api.KieBase;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.PMML_STEP;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.models.PMMLStep;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLListener;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.evaluator.api.executor.PMMLRuntimeInternal;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluatorFinderImpl;
import org.kie.pmml.evaluator.core.implementations.PMMLRuntimeStep;
import org.kie.pmml.evaluator.core.utils.KnowledgeBaseUtils;
import org.kie.pmml.evaluator.core.utils.PMMLListenerUtils;
import org.kie.pmml.evaluator.core.utils.PostProcess;
import org.kie.pmml.evaluator.core.utils.PreProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLRuntimeInternalImpl
implements PMMLRuntimeInternal {
    private static final Logger logger = LoggerFactory.getLogger(PMMLRuntimeInternalImpl.class);
    private final KieBase knowledgeBase;
    private final PMMLModelEvaluatorFinderImpl pmmlModelExecutorFinder;
    private final Set<PMMLListener> pmmlListeners = new HashSet<PMMLListener>();

    public PMMLRuntimeInternalImpl(KieBase knowledgeBase, PMMLModelEvaluatorFinderImpl pmmlModelExecutorFinder) {
        this.knowledgeBase = knowledgeBase;
        this.pmmlModelExecutorFinder = pmmlModelExecutorFinder;
    }

    public KieBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public List<KiePMMLModel> getKiePMMLModels() {
        return KnowledgeBaseUtils.getModels(this.knowledgeBase);
    }

    public List<PMMLModel> getPMMLModels() {
        List<KiePMMLModel> kiePMMLModels = this.getKiePMMLModels();
        return new ArrayList<KiePMMLModel>(kiePMMLModels);
    }

    public Optional<KiePMMLModel> getKiePMMLModel(String modelName) {
        return KnowledgeBaseUtils.getModel(this.knowledgeBase, modelName);
    }

    public Optional<PMMLModel> getPMMLModel(String modelName) {
        return this.getKiePMMLModel(modelName).map(KiePMMLModel.class::cast);
    }

    public PMML4Result evaluate(String modelName, PMMLContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("evaluate {} {}", (Object)modelName, (Object)context);
        }
        KiePMMLModel toEvaluate = this.getKiePMMLModel(modelName).orElseThrow(() -> new KiePMMLException("Failed to retrieve model with name " + modelName));
        return this.evaluate(toEvaluate, context);
    }

    public void addPMMLListener(PMMLListener toAdd) {
        this.pmmlListeners.add(toAdd);
    }

    public void removePMMLListener(PMMLListener toRemove) {
        this.pmmlListeners.remove(toRemove);
    }

    public Set<PMMLListener> getPMMLListeners() {
        return Collections.unmodifiableSet(this.pmmlListeners);
    }

    protected PMML4Result evaluate(KiePMMLModel model, PMMLContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("evaluate {} {}", (Object)model, (Object)context);
        }
        this.pmmlListeners.forEach(arg_0 -> ((PMMLContext)context).addPMMLListener(arg_0));
        this.addStep(() -> this.getStep(PMML_STEP.START, model, context.getRequestData()), context);
        ProcessingDTO processingDTO = PreProcess.preProcess(model, context);
        this.addStep(() -> this.getStep(PMML_STEP.PRE_EVALUATION, model, context.getRequestData()), context);
        PMMLModelEvaluator executor = this.getFromPMMLModelType(model.getPmmlMODEL()).orElseThrow(() -> new KiePMMLException(String.format("PMMLModelEvaluator not found for model %s", model.getPmmlMODEL())));
        PMML4Result toReturn = executor.evaluate(this.knowledgeBase, model, context);
        this.addStep(() -> this.getStep(PMML_STEP.POST_EVALUATION, model, context.getRequestData()), context);
        PostProcess.postProcess(toReturn, model, context, processingDTO);
        this.addStep(() -> this.getStep(PMML_STEP.END, model, context.getRequestData()), context);
        return toReturn;
    }

    void addStep(Supplier<PMMLStep> stepSupplier, PMMLContext pmmlContext) {
        PMMLListenerUtils.stepExecuted(stepSupplier, pmmlContext);
    }

    PMMLStep getStep(PMML_STEP pmmlStep, KiePMMLModel model, PMMLRequestData requestData) {
        PMMLRuntimeStep toReturn = new PMMLRuntimeStep(pmmlStep);
        toReturn.addInfo("MODEL", model.getName());
        toReturn.addInfo("CORRELATION ID", requestData.getCorrelationId());
        toReturn.addInfo("REQUEST MODEL", requestData.getModelName());
        requestData.getRequestParams().forEach(requestParam -> toReturn.addInfo(requestParam.getName(), requestParam.getValue()));
        return toReturn;
    }

    private Optional<PMMLModelEvaluator> getFromPMMLModelType(PMML_MODEL pmmlMODEL) {
        logger.trace("getFromPMMLModelType {}", (Object)pmmlMODEL);
        return this.pmmlModelExecutorFinder.getImplementations(false).stream().filter(implementation -> pmmlMODEL.equals((Object)implementation.getPMMLModelType())).findFirst();
    }
}

