/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.mariadb.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.sql.SQLException;
import org.mariadb.jdbc.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.authentication.AuthenticationPluginLoader;
import org.mariadb.jdbc.internal.com.send.authentication.ClearPasswordPlugin;
import org.mariadb.jdbc.internal.com.send.authentication.Ed25519PasswordPlugin;
import org.mariadb.jdbc.internal.com.send.authentication.NativePasswordPlugin;
import org.mariadb.jdbc.internal.com.send.authentication.OldPasswordPlugin;
import org.mariadb.jdbc.internal.com.send.authentication.SendGssApiAuthPacket;

@TargetClass(value=AuthenticationPluginLoader.class)
@Substitute
public final class AuthenticationPluginLoader_Substitutions {
    public static final String MYSQL_NATIVE_PASSWORD = "mysql_native_password";
    public static final String MYSQL_OLD_PASSWORD = "mysql_old_password";
    public static final String MYSQL_CLEAR_PASSWORD = "mysql_clear_password";
    public static final String MYSQL_ED25519_PASSWORD = "client_ed25519";
    private static final String GSSAPI_CLIENT = "auth_gssapi_client";
    private static final String DIALOG = "dialog";

    @Substitute
    public static AuthenticationPlugin get(String type) throws SQLException {
        switch (type) {
            case "mysql_native_password": {
                return new NativePasswordPlugin();
            }
            case "mysql_old_password": {
                return new OldPasswordPlugin();
            }
            case "mysql_clear_password": {
                return new ClearPasswordPlugin();
            }
            case "dialog": {
                throw new UnsupportedOperationException("Authentication strategy 'dialog' is not supported in GraalVM");
            }
            case "auth_gssapi_client": {
                return new SendGssApiAuthPacket();
            }
            case "client_ed25519": {
                return new Ed25519PasswordPlugin();
            }
        }
        throw new SQLException("Client does not support authentication protocol requested by server. Consider upgrading MariaDB client. plugin was = " + type, "08004", 1251);
    }
}

