/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.db2.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DB2DevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(DB2DevServicesProcessor.class);
    public static final String TAG = "11.5.5.1";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupDB2(final Optional<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("db2", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties, OptionalInt fixedExposedPort, LaunchMode launchMode) {
                final Db2Container container = new QuarkusDb2Container(imageName, fixedExposedPort, devServicesSharedNetworkBuildItem.isPresent()).withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default"));
                additionalProperties.forEach((arg_0, arg_1) -> ((Db2Container)container).withUrlParam(arg_0, arg_1));
                container.start();
                LOG.info((Object)"Dev Services for IBM Db2 started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                        LOG.info((Object)"Dev Services for IBM Db2 shut down.");
                    }
                });
            }
        });
    }

    private static class QuarkusDb2Container
    extends Db2Container {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusDb2Container(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElse("ibmcom/db2:11.5.5.1")).asCompatibleSubstituteFor(DockerImageName.parse((String)"ibmcom/db2")));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"db2");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 50000);
            }
        }

        public String getJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters(":", ";", ";");
                return "jdbc:db2://" + this.hostName + ":50000/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }
    }
}

