/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.Array;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.clustering.compiler.dto.ClusteringCompilationDTO;
import org.kie.pmml.models.clustering.compiler.factories.KiePMMLClusteringConversionUtils;
import org.kie.pmml.models.clustering.model.KiePMMLCluster;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringField;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModel;
import org.kie.pmml.models.clustering.model.KiePMMLCompareFunction;
import org.kie.pmml.models.clustering.model.KiePMMLComparisonMeasure;
import org.kie.pmml.models.clustering.model.KiePMMLMissingValueWeights;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLClusteringModelFactory {
    static final String KIE_PMML_CLUSTERING_MODEL_TEMPLATE_JAVA = "KiePMMLClusteringModelTemplate.tmpl";
    static final String KIE_PMML_CLUSTERING_MODEL_TEMPLATE = "KiePMMLClusteringModelTemplate";
    static final String GET_CLUSTERS = "getClusters";
    static final String GET_CLUSTERING_FIELDS = "getClusteringFields";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLClusteringModelFactory.class.getName());

    private KiePMMLClusteringModelFactory() {
    }

    public static KiePMMLClusteringModel getKiePMMLClusteringModel(ClusteringCompilationDTO compilationDTO) {
        logger.trace("getKiePMMLClusteringModel {}", (Object)compilationDTO);
        try {
            ClusteringModel clusteringModel = (ClusteringModel)compilationDTO.getModel();
            KiePMMLClusteringModel.ModelClass modelClass = KiePMMLClusteringConversionUtils.modelClassFrom(clusteringModel.getModelClass());
            List<KiePMMLCluster> clusters = KiePMMLClusteringModelFactory.getKiePMMLClusters(clusteringModel.getClusters());
            List<KiePMMLClusteringField> clusteringFields = KiePMMLClusteringModelFactory.getKiePMMLClusteringFields(clusteringModel.getClusteringFields());
            KiePMMLComparisonMeasure comparisonMeasure = KiePMMLClusteringModelFactory.getKiePMMLComparisonMeasure(clusteringModel.getComparisonMeasure());
            KiePMMLMissingValueWeights missingValueWeights = KiePMMLClusteringModelFactory.getKiePMMLMissingValueWeights(clusteringModel.getMissingValueWeights());
            return (KiePMMLClusteringModel)KiePMMLClusteringModel.builder((String)compilationDTO.getModelName(), (MINING_FUNCTION)compilationDTO.getMINING_FUNCTION()).withModelClass(modelClass).withClusters(clusters).withClusteringFields(clusteringFields).withComparisonMeasure(comparisonMeasure).withMissingValueWeights(missingValueWeights).withTargetField(compilationDTO.getTargetFieldName()).withMiningFields(compilationDTO.getKieMiningFields()).withOutputFields(compilationDTO.getKieOutputFields()).withKiePMMLMiningFields(compilationDTO.getKiePMMLMiningFields()).withKiePMMLOutputFields(compilationDTO.getKiePMMLOutputFields()).withKiePMMLTargets(compilationDTO.getKiePMMLTargetFields()).withKiePMMLTransformationDictionary(compilationDTO.getKiePMMLTransformationDictionary()).withKiePMMLLocalTransformations(compilationDTO.getKiePMMLLocalTransformations()).build();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLClusteringModelSourcesMap(ClusteringCompilationDTO compilationDTO) {
        logger.trace("getKiePMMLClusteringModelSourcesMap {}", (Object)compilationDTO);
        String simpleClassName = compilationDTO.getSimpleClassName();
        CompilationUnit compilationUnit = JavaParserUtils.getKiePMMLModelCompilationUnit((String)simpleClassName, (String)compilationDTO.getPackageName(), (String)KIE_PMML_CLUSTERING_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_CLUSTERING_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)compilationUnit.getClassByName(simpleClassName).orElseThrow(() -> new KiePMMLException("Main class not found: " + simpleClassName));
        KiePMMLClusteringModelFactory.setStaticGetter((CompilationDTO<ClusteringModel>)compilationDTO, modelTemplate);
        KiePMMLClusteringModelFactory.populateGetClustersMethod(modelTemplate, (ClusteringModel)compilationDTO.getModel());
        KiePMMLClusteringModelFactory.populateGetClusteringFieldsMethod(modelTemplate, (ClusteringModel)compilationDTO.getModel());
        HashMap<String, String> sourcesMap = new HashMap<String, String>();
        sourcesMap.put(JavaParserUtils.getFullClassName((CompilationUnit)compilationUnit), compilationUnit.toString());
        return sourcesMap;
    }

    static List<KiePMMLCluster> getKiePMMLClusters(List<Cluster> clusters) {
        return clusters != null ? clusters.stream().map(KiePMMLClusteringModelFactory::getKiePMMLCluster).collect(Collectors.toList()) : Collections.emptyList();
    }

    static KiePMMLCluster getKiePMMLCluster(Cluster cluster) {
        List<Double> values = KiePMMLClusteringModelFactory.getClusterDoubleValues(cluster);
        return new KiePMMLCluster(cluster.getId(), cluster.getName(), values);
    }

    static List<KiePMMLClusteringField> getKiePMMLClusteringFields(List<ClusteringField> clusteringFields) {
        return clusteringFields != null ? clusteringFields.stream().map(KiePMMLClusteringModelFactory::getKiePMMLClusteringField).collect(Collectors.toList()) : Collections.emptyList();
    }

    static KiePMMLClusteringField getKiePMMLClusteringField(ClusteringField clusteringField) {
        double fieldWeight = clusteringField.getFieldWeight() == null ? 1.0 : clusteringField.getFieldWeight().doubleValue();
        boolean isCenterField = clusteringField.getCenterField() == null || clusteringField.getCenterField() == ClusteringField.CenterField.TRUE;
        KiePMMLCompareFunction kiePMMLCompareFunction = clusteringField.getCompareFunction() != null ? KiePMMLClusteringConversionUtils.compareFunctionFrom(clusteringField.getCompareFunction()) : null;
        return new KiePMMLClusteringField(clusteringField.getField().getValue(), Double.valueOf(fieldWeight), Boolean.valueOf(isCenterField), kiePMMLCompareFunction, null);
    }

    static KiePMMLComparisonMeasure getKiePMMLComparisonMeasure(ComparisonMeasure comparisonMeasure) {
        return new KiePMMLComparisonMeasure(KiePMMLClusteringConversionUtils.comparisonMeasureKindFrom(comparisonMeasure.getKind()), KiePMMLClusteringConversionUtils.aggregateFunctionFrom(comparisonMeasure.getMeasure()), KiePMMLClusteringConversionUtils.compareFunctionFrom(comparisonMeasure.getCompareFunction()));
    }

    static KiePMMLMissingValueWeights getKiePMMLMissingValueWeights(MissingValueWeights missingValueWeights) {
        return missingValueWeights != null ? new KiePMMLMissingValueWeights(KiePMMLClusteringModelFactory.getMissingValueWeightsDoubleValues(missingValueWeights)) : null;
    }

    static void setStaticGetter(CompilationDTO<ClusteringModel> compilationDTO, ClassOrInterfaceDeclaration modelTemplate) {
        KiePMMLModelFactoryUtils.initStaticGetter(compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        BlockStmt body = CommonCodegenUtils.getMethodDeclarationBlockStmt((ClassOrInterfaceDeclaration)modelTemplate, (String)"getModel");
        VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"toReturn").orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", "toReturn", body)));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", "toReturn", body)))).asMethodCallExpr();
        ClusteringModel clusteringModel = (ClusteringModel)compilationDTO.getModel();
        KiePMMLClusteringModel.ModelClass modelClass = KiePMMLClusteringConversionUtils.modelClassFrom(clusteringModel.getModelClass());
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withModelClass", (MethodCallExpr)initializer).setArgument(0, CommonCodegenUtils.literalExprFrom((Enum)modelClass));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withComparisonMeasure", (MethodCallExpr)initializer).setArgument(0, (Expression)KiePMMLClusteringModelFactory.comparisonMeasureCreationExprFrom(clusteringModel.getComparisonMeasure()));
        NullLiteralExpr missingValueWeights = clusteringModel.getMissingValueWeights() != null ? KiePMMLClusteringModelFactory.missingValueWeightsCreationExprFrom(clusteringModel.getMissingValueWeights()) : new NullLiteralExpr();
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withMissingValueWeights", (MethodCallExpr)initializer).setArgument(0, (Expression)missingValueWeights);
    }

    static void populateGetClustersMethod(ClassOrInterfaceDeclaration toPopulate, ClusteringModel clusteringModel) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)toPopulate, (String)GET_CLUSTERS).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected method '%s' in class %s", toPopulate, GET_CLUSTERS)));
        List objectCreationExprStream = clusteringModel.getClusters().stream().map(KiePMMLClusteringModelFactory::clusterCreationExprFrom).collect(Collectors.toList());
        CommonCodegenUtils.populateListInListGetter(objectCreationExprStream, (MethodDeclaration)methodDeclaration, (String)"toReturn");
    }

    static void populateGetClusteringFieldsMethod(ClassOrInterfaceDeclaration toPopulate, ClusteringModel clusteringModel) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)toPopulate, (String)GET_CLUSTERING_FIELDS).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected method '%s' in class %s", toPopulate, GET_CLUSTERING_FIELDS)));
        List objectCreationExprStream = clusteringModel.getClusteringFields().stream().map(KiePMMLClusteringModelFactory::clusteringFieldCreationExprFrom).collect(Collectors.toList());
        CommonCodegenUtils.populateListInListGetter(objectCreationExprStream, (MethodDeclaration)methodDeclaration, (String)"toReturn");
    }

    private static ObjectCreationExpr clusterCreationExprFrom(Cluster cluster) {
        NodeList arguments = new NodeList();
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((String)cluster.getId()));
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((String)cluster.getName()));
        List<Double> values = KiePMMLClusteringModelFactory.getClusterDoubleValues(cluster);
        arguments.add((Node)CommonCodegenUtils.createArraysAsListFromList(values).getExpression());
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLCluster.class.getCanonicalName()), arguments);
    }

    private static ObjectCreationExpr clusteringFieldCreationExprFrom(ClusteringField clusteringField) {
        double fieldWeight = clusteringField.getFieldWeight() == null ? 1.0 : clusteringField.getFieldWeight().doubleValue();
        boolean isCenterField = clusteringField.getCenterField() == null || clusteringField.getCenterField() == ClusteringField.CenterField.TRUE;
        NodeList arguments = new NodeList();
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((String)clusteringField.getField().getValue()));
        arguments.add((Node)new DoubleLiteralExpr(fieldWeight));
        arguments.add((Node)new BooleanLiteralExpr(isCenterField));
        arguments.add((Node)(clusteringField.getCompareFunction() == null ? new NullLiteralExpr() : CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.compareFunctionFrom(clusteringField.getCompareFunction()))));
        arguments.add((Node)new NullLiteralExpr());
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLClusteringField.class.getCanonicalName()), arguments);
    }

    private static ObjectCreationExpr comparisonMeasureCreationExprFrom(ComparisonMeasure comparisonMeasure) {
        NodeList arguments = new NodeList();
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.comparisonMeasureKindFrom(comparisonMeasure.getKind())));
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.aggregateFunctionFrom(comparisonMeasure.getMeasure())));
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.compareFunctionFrom(comparisonMeasure.getCompareFunction())));
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLComparisonMeasure.class.getCanonicalName()), arguments);
    }

    private static ObjectCreationExpr missingValueWeightsCreationExprFrom(MissingValueWeights missingValueWeights) {
        NodeList arguments = new NodeList();
        List<Double> values = KiePMMLClusteringModelFactory.getMissingValueWeightsDoubleValues(missingValueWeights);
        arguments.add((Node)CommonCodegenUtils.createArraysAsListFromList(values).getExpression());
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLMissingValueWeights.class.getCanonicalName()), arguments);
    }

    private static List<Double> getClusterDoubleValues(Cluster cluster) {
        return cluster.getArray() != null ? KiePMMLClusteringModelFactory.getDoubleValuesFromArray(cluster.getArray()) : Collections.emptyList();
    }

    private static List<Double> getMissingValueWeightsDoubleValues(MissingValueWeights missingValueWeights) {
        return missingValueWeights.getArray() != null ? KiePMMLClusteringModelFactory.getDoubleValuesFromArray(missingValueWeights.getArray()) : Collections.emptyList();
    }

    private static List<Double> getDoubleValuesFromArray(Array array) {
        ArrayList<Double> toReturn = new ArrayList<Double>();
        if (array.getType() == Array.Type.REAL) {
            String arrayStringValue = (String)array.getValue();
            String[] arrayStringChunks = arrayStringValue.split(" ");
            try {
                Arrays.stream(arrayStringChunks).map(Double::parseDouble).forEach(toReturn::add);
            }
            catch (NumberFormatException e) {
                logger.error("Can't parse \"real\" cluster with value \"" + arrayStringValue + "\"", (Throwable)e);
            }
        }
        return toReturn;
    }
}

