/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.BootstrapGradleException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.model.gradle.QuarkusModel;
import io.quarkus.bootstrap.model.gradle.WorkspaceModule;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.util.PathsUtils;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.dev.spi.DevModeType;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class IDEDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>>,
Closeable {
    private static final Logger log = Logger.getLogger((String)IDEDevModeMain.class.getName());
    private static final String APP_PROJECT = "app-project";
    private IsolatedDevModeMain delegate;

    @Override
    public void accept(CuratedApplication curatedApplication, Map<String, Object> stringObjectMap) {
        Path appClasses = (Path)stringObjectMap.get("app-classes");
        DevModeContext devModeContext = new DevModeContext();
        devModeContext.setArgs((String[])stringObjectMap.get("args"));
        try {
            if (BuildToolHelper.isMavenProject((Path)appClasses)) {
                LocalProject project = (LocalProject)stringObjectMap.get(APP_PROJECT);
                if (project == null) {
                    project = LocalProject.loadWorkspace((Path)appClasses);
                }
                DevModeContext.ModuleInfo root = this.toModule(project);
                devModeContext.setApplicationRoot(root);
                LocalWorkspace workspace = project.getWorkspace();
                for (AppArtifactKey localKey : curatedApplication.getAppModel().getLocalProjectArtifacts()) {
                    LocalProject depProject = workspace.getProject(localKey.getGroupId(), localKey.getArtifactId());
                    if (project == depProject) continue;
                    if (depProject == null) {
                        throw new IllegalStateException("Failed to locate project dependency " + localKey + " in the workspace");
                    }
                    devModeContext.getAdditionalModules().add(this.toModule(depProject));
                    devModeContext.getLocalArtifacts().add(localKey);
                }
            } else {
                QuarkusModel model = QuarkusModelHelper.deserializeQuarkusModel((Path)((Path)stringObjectMap.get("quarkus-internal.serialized-quarkus-model.path")));
                WorkspaceModule launchingModule = model.getWorkspace().getMainModule();
                DevModeContext.ModuleInfo root = this.toModule(launchingModule);
                devModeContext.setApplicationRoot(root);
                for (WorkspaceModule additionalModule : model.getWorkspace().getAllModules()) {
                    if (additionalModule.getArtifactCoords().equals(launchingModule.getArtifactCoords())) continue;
                    devModeContext.getAdditionalModules().add(this.toModule(additionalModule));
                }
            }
        }
        catch (AppModelResolverException e) {
            log.error((Object)"Failed to load workspace, hot reload will not be available", (Throwable)e);
        }
        this.terminateIfRunning();
        this.delegate = new IsolatedDevModeMain();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DevModeContext.class.getName(), devModeContext);
        params.put(DevModeType.class.getName(), DevModeType.LOCAL);
        this.delegate.accept(curatedApplication, (Map<String, Object>)params);
    }

    @Override
    public void close() {
        this.terminateIfRunning();
    }

    private void terminateIfRunning() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private DevModeContext.ModuleInfo toModule(WorkspaceModule module) throws BootstrapGradleException {
        AppArtifactKey key = new AppArtifactKey(module.getArtifactCoords().getGroupId(), module.getArtifactCoords().getArtifactId(), module.getArtifactCoords().getClassifier());
        LinkedHashSet<Path> sourceParents = new LinkedHashSet<Path>();
        for (File srcDir : module.getSourceSourceSet().getSourceDirectories()) {
            sourceParents.add(srcDir.getParentFile().toPath());
        }
        String resourceDirectory = null;
        if (!module.getSourceSet().getResourceDirectories().isEmpty()) {
            resourceDirectory = ((File)module.getSourceSet().getResourceDirectories().iterator().next()).toString();
        }
        return new DevModeContext.ModuleInfo.Builder().setAppArtifactKey(key).setName(module.getArtifactCoords().getArtifactId()).setProjectDirectory(module.getProjectRoot().getPath()).setSourcePaths(PathsUtils.toPathsCollection((Collection)module.getSourceSourceSet().getSourceDirectories())).setClassesPath(QuarkusModelHelper.getClassPath((WorkspaceModule)module).toAbsolutePath().toString()).setResourcePaths(PathsUtils.toPathsCollection((Collection)module.getSourceSourceSet().getResourceDirectories())).setResourcesOutputPath(resourceDirectory).setSourceParents(PathsCollection.from(sourceParents)).setPreBuildOutputDir(module.getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(module.getBuildDir().toString()).build();
    }

    private DevModeContext.ModuleInfo toModule(LocalProject project) {
        return new DevModeContext.ModuleInfo.Builder().setAppArtifactKey(project.getKey()).setName(project.getArtifactId()).setProjectDirectory(project.getDir().toAbsolutePath().toString()).setSourcePaths(PathsCollection.of((Path[])new Path[]{project.getSourcesSourcesDir().toAbsolutePath()})).setClassesPath(project.getClassesDir().toAbsolutePath().toString()).setResourcesOutputPath(project.getClassesDir().toAbsolutePath().toString()).setResourcePaths(PathsCollection.from((Iterable)project.getResourcesSourcesDirs().toList().stream().map(Path::toAbsolutePath).collect(Collectors.toCollection(LinkedHashSet::new)))).setSourceParents(PathsCollection.of((Path[])new Path[]{project.getSourcesDir()})).setPreBuildOutputDir(project.getCodeGenOutputDir().toString()).setTargetDir(project.getOutputDir().toString()).setTestSourcePaths(PathsCollection.of((Path[])new Path[]{project.getTestSourcesSourcesDir()})).setTestClassesPath(project.getTestClassesDir().toAbsolutePath().toString()).setTestResourcesOutputPath(project.getTestClassesDir().toAbsolutePath().toString()).setTestResourcePaths(PathsCollection.from((Iterable)project.getTestResourcesSourcesDirs())).build();
    }
}

