/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.bootstrap.classloading.JarClassPathElement;
import io.quarkus.deployment.util.IoUtil;
import io.smallrye.common.io.jar.JarFiles;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class IndexingUtil {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.deployment.index");
    public static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final String JANDEX_INDEX = "META-INF/jandex.idx";
    private static final int REQUIRED_INDEX_VERSION = 8;

    public static Index indexJar(Path path) throws IOException {
        return IndexingUtil.indexJar(path.toFile(), Collections.emptySet());
    }

    public static Index indexJar(File file) throws IOException {
        return IndexingUtil.indexJar(file, Collections.emptySet());
    }

    public static Index indexJar(Path path, Set<String> removed) throws IOException {
        return IndexingUtil.indexJar(path.toFile(), removed);
    }

    public static Index indexJar(File file, Set<String> removed) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            ZipEntry existing = jarFile.getEntry(JANDEX_INDEX);
            if (existing != null && removed == null) {
                InputStream in = jarFile.getInputStream(existing);
                IndexReader reader = new IndexReader(in);
                if (reader.getIndexVersion() < 8) {
                    log.warnf("Re-indexing %s - at least Jandex 2.1 must be used to index an application dependency", (Object)file);
                    Index index = IndexingUtil.indexJar(jarFile, removed);
                    return index;
                }
                Index index = reader.read();
                return index;
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            Index index = IndexingUtil.indexJar(jarFile, removed);
            return index;
        }
    }

    private static Index indexJar(JarFile file, Set<String> removed) throws IOException {
        Indexer indexer = new Indexer();
        Enumeration<JarEntry> e = file.entries();
        boolean multiRelease = JarFiles.isMultiRelease((JarFile)file);
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (removed != null && removed.contains(entry.getName()) || !entry.getName().endsWith(".class")) continue;
            if (multiRelease && entry.getName().startsWith("META-INF/versions/")) {
                String part = entry.getName().substring("META-INF/versions/".length());
                int slash = part.indexOf("/");
                if (slash == -1) continue;
                try {
                    int ver = Integer.parseInt(part.substring(0, slash));
                    if (ver > JarClassPathElement.JAVA_VERSION) continue;
                    try (InputStream inputStream = file.getInputStream(entry);){
                        indexer.index(inputStream);
                    }
                }
                catch (NumberFormatException ex) {
                    log.debug((Object)"Failed to parse META-INF/versions entry", (Throwable)ex);
                }
                continue;
            }
            InputStream inputStream = file.getInputStream(entry);
            try {
                indexer.index(inputStream);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return indexer.complete();
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader) {
        ClassInfo classInfo;
        block20: {
            DotName classDotName = DotName.createSimple((String)className);
            if (additionalIndex.contains(classDotName)) {
                return;
            }
            classInfo = quarkusIndex.getClassByName(classDotName);
            if (classInfo == null) {
                log.debugf("Index class: %s", (Object)className);
                try (InputStream stream = IoUtil.readClass(classLoader, className);){
                    classInfo = indexer.index(stream);
                    additionalIndex.add(classInfo.name());
                    break block20;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to index: " + className, e);
                }
            }
            additionalIndex.add(classDotName);
        }
        for (DotName annotationName : classInfo.annotations().keySet()) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                try {
                    if (annotationStream == null) {
                        log.debugf("Could not index annotation: %s (missing class or dependency)", (Object)annotationName);
                        continue;
                    }
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    indexer.index(annotationStream);
                    additionalIndex.add(annotationName);
                }
                finally {
                    if (annotationStream == null) continue;
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + className, e);
            }
        }
        if (classInfo.superName() != null && !classInfo.superName().equals((Object)OBJECT)) {
            IndexingUtil.indexClass(classInfo.superName().toString(), indexer, quarkusIndex, additionalIndex, classLoader);
        }
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader, byte[] beanData) {
        ClassInfo classInfo;
        block17: {
            DotName classDotName = DotName.createSimple((String)className);
            if (additionalIndex.contains(classDotName)) {
                return;
            }
            classInfo = quarkusIndex.getClassByName(classDotName);
            if (classInfo == null) {
                log.debugf("Index class: %s", (Object)className);
                try (ByteArrayInputStream stream = new ByteArrayInputStream(beanData);){
                    classInfo = indexer.index((InputStream)stream);
                    additionalIndex.add(classInfo.name());
                    break block17;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to index: " + className, e);
                }
            }
            additionalIndex.add(classDotName);
        }
        for (DotName annotationName : classInfo.annotations().keySet()) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                try {
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    indexer.index(annotationStream);
                    additionalIndex.add(annotationName);
                }
                finally {
                    if (annotationStream == null) continue;
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + className, e);
            }
        }
    }
}

