/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.commons.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class OffsetDateTimeXStreamConverter
implements Converter {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffsetId().toFormatter();

    public void marshal(Object localTimeObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        OffsetDateTime offsetDateTime = (OffsetDateTime)localTimeObject;
        writer.setValue(this.formatter.format(offsetDateTime));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String offsetDateTimeString = reader.getValue();
        try {
            return OffsetDateTime.from(this.formatter.parse(offsetDateTimeString));
        }
        catch (DateTimeException e) {
            throw new IllegalStateException("Failed to convert string (" + offsetDateTimeString + ") to type (" + OffsetDateTime.class.getName() + ").");
        }
    }

    public boolean canConvert(Class type) {
        return OffsetDateTime.class.isAssignableFrom(type);
    }
}

