/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.anchor;

import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.anchor.ExternalizedAnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class AnchorVariableDemand
implements Demand<AnchorVariableSupply> {
    protected final VariableDescriptor sourceVariableDescriptor;

    public AnchorVariableDemand(VariableDescriptor sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    public VariableDescriptor getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public AnchorVariableSupply createExternalizedSupply(InnerScoreDirector scoreDirector) {
        SingletonInverseVariableSupply inverseVariableSupply = scoreDirector.getSupplyManager().demand(new SingletonInverseVariableDemand(this.sourceVariableDescriptor));
        return new ExternalizedAnchorVariableSupply(this.sourceVariableDescriptor, inverseVariableSupply);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnchorVariableDemand)) {
            return false;
        }
        AnchorVariableDemand other = (AnchorVariableDemand)o;
        return this.sourceVariableDescriptor.equals(other.sourceVariableDescriptor);
    }

    public int hashCode() {
        return Objects.hash(AnchorVariableDemand.class.getName(), this.sourceVariableDescriptor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getSimpleEntityAndVariableName() + ")";
    }
}

