/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.drools.model.DeclarationSource;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;

public final class DroolsPatternBuilder<T> {
    private final Variable<T> baseVariable;
    private final Function<PatternDSL.PatternDef<T>, PatternDSL.PatternDef<T>> builder;

    public DroolsPatternBuilder(Variable<T> baseVariable) {
        this.baseVariable = baseVariable;
        this.builder = null;
    }

    private DroolsPatternBuilder(Variable<T> baseVariable, Function<PatternDSL.PatternDef<T>, PatternDSL.PatternDef<T>> builder) {
        this.baseVariable = baseVariable;
        this.builder = builder;
    }

    public DroolsPatternBuilder<T> expand(UnaryOperator<PatternDSL.PatternDef<T>> expander) {
        UnaryOperator<PatternDSL.PatternDef<T>> newBuilder = this.builder == null ? expander : this.builder.andThen(expander);
        return new DroolsPatternBuilder<T>(this.baseVariable, newBuilder);
    }

    private PatternDSL.PatternDef<T> build(PatternDSL.PatternDef<T> basePattern) {
        if (this.builder == null) {
            return basePattern;
        }
        return this.builder.apply(basePattern);
    }

    public PatternDSL.PatternDef<T> build() {
        return this.build(PatternDSL.pattern(this.baseVariable));
    }

    public PatternDSL.PatternDef<T> build(DeclarationSource declarationSource) {
        return this.build(PatternDSL.pattern(this.baseVariable, (DeclarationSource)declarationSource));
    }

    public Variable<T> getBaseVariable() {
        return this.baseVariable;
    }
}

