/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.PentaFunction;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractUniCollectingGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;

final class DroolsQuadToBiGroupByAccumulator<A, B, C, D, ResultContainer, NewA, NewB>
extends DroolsAbstractUniCollectingGroupByAccumulator<ResultContainer, QuadTuple<A, B, C, D>, NewA, BiTuple<NewA, NewB>> {
    private final QuadFunction<A, B, C, D, NewA> groupKeyMapping;
    private final Supplier<ResultContainer> supplier;
    private final PentaFunction<ResultContainer, A, B, C, D, Runnable> accumulator;
    private final Function<ResultContainer, NewB> finisher;

    public DroolsQuadToBiGroupByAccumulator(QuadFunction<A, B, C, D, NewA> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainer, NewB> collector) {
        this.groupKeyMapping = groupKeyMapping;
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    @Override
    protected NewA toKey(QuadTuple<A, B, C, D> abcdQuadTuple) {
        return this.groupKeyMapping.apply(abcdQuadTuple.a, abcdQuadTuple.b, abcdQuadTuple.c, abcdQuadTuple.d);
    }

    @Override
    protected ResultContainer newContainer() {
        return this.supplier.get();
    }

    @Override
    protected Runnable process(QuadTuple<A, B, C, D> abcdQuadTuple, ResultContainer container) {
        return this.accumulator.apply(container, abcdQuadTuple.a, abcdQuadTuple.b, abcdQuadTuple.c, abcdQuadTuple.d);
    }

    @Override
    protected BiTuple<NewA, NewB> toResult(NewA key, ResultContainer container) {
        return new BiTuple<NewA, NewB>(key, this.finisher.apply(container));
    }
}

