/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.loader.FileProblemProvider;
import org.optaplanner.benchmark.impl.loader.InstanceProblemProvider;
import org.optaplanner.benchmark.impl.loader.ProblemProvider;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

@XStreamAlias(value="problemBenchmarks")
public class ProblemBenchmarksConfig
extends AbstractConfig<ProblemBenchmarksConfig> {
    private Class<SolutionFileIO> solutionFileIOClass = null;
    @XStreamImplicit(itemFieldName="xStreamAnnotatedClass")
    private List<Class> xStreamAnnotatedClassList = null;
    private Boolean writeOutputSolutionEnabled = null;
    @XStreamImplicit(itemFieldName="inputSolutionFile")
    private List<File> inputSolutionFileList = null;
    private Boolean problemStatisticEnabled = null;
    @XStreamImplicit(itemFieldName="problemStatisticType")
    private List<ProblemStatisticType> problemStatisticTypeList = null;
    @XStreamImplicit(itemFieldName="singleStatisticType")
    private List<SingleStatisticType> singleStatisticTypeList = null;

    public Class<SolutionFileIO> getSolutionFileIOClass() {
        return this.solutionFileIOClass;
    }

    public void setSolutionFileIOClass(Class<SolutionFileIO> solutionFileIOClass) {
        this.solutionFileIOClass = solutionFileIOClass;
    }

    public List<Class> getXStreamAnnotatedClassList() {
        return this.xStreamAnnotatedClassList;
    }

    public void setXStreamAnnotatedClassList(List<Class> xStreamAnnotatedClassList) {
        this.xStreamAnnotatedClassList = xStreamAnnotatedClassList;
    }

    public Boolean getWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(Boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public List<File> getInputSolutionFileList() {
        return this.inputSolutionFileList;
    }

    public void setInputSolutionFileList(List<File> inputSolutionFileList) {
        this.inputSolutionFileList = inputSolutionFileList;
    }

    public Boolean getProblemStatisticEnabled() {
        return this.problemStatisticEnabled;
    }

    public void setProblemStatisticEnabled(Boolean problemStatisticEnabled) {
        this.problemStatisticEnabled = problemStatisticEnabled;
    }

    public List<ProblemStatisticType> getProblemStatisticTypeList() {
        return this.problemStatisticTypeList;
    }

    public void setProblemStatisticTypeList(List<ProblemStatisticType> problemStatisticTypeList) {
        this.problemStatisticTypeList = problemStatisticTypeList;
    }

    public List<SingleStatisticType> getSingleStatisticTypeList() {
        return this.singleStatisticTypeList;
    }

    public void setSingleStatisticTypeList(List<SingleStatisticType> singleStatisticTypeList) {
        this.singleStatisticTypeList = singleStatisticTypeList;
    }

    public <Solution_> void buildProblemBenchmarkList(SolverConfigContext solverConfigContext, SolverBenchmarkResult solverBenchmarkResult, Solution_[] extraProblems) {
        PlannerBenchmarkResult plannerBenchmarkResult = solverBenchmarkResult.getPlannerBenchmarkResult();
        List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList();
        for (ProblemProvider<Solution_> problemProvider : this.buildProblemProviderList(solverConfigContext, solverBenchmarkResult, extraProblems)) {
            ProblemBenchmarkResult problemBenchmarkResult;
            ProblemBenchmarkResult newProblemBenchmarkResult = this.buildProblemBenchmark(solverConfigContext, plannerBenchmarkResult, problemProvider);
            int index = unifiedProblemBenchmarkResultList.indexOf(newProblemBenchmarkResult);
            if (index < 0) {
                problemBenchmarkResult = newProblemBenchmarkResult;
                unifiedProblemBenchmarkResultList.add(problemBenchmarkResult);
            } else {
                problemBenchmarkResult = unifiedProblemBenchmarkResultList.get(index);
            }
            this.buildSingleBenchmark(solverConfigContext, solverBenchmarkResult, problemBenchmarkResult);
        }
    }

    private <Solution_> List<ProblemProvider<Solution_>> buildProblemProviderList(SolverConfigContext solverConfigContext, SolverBenchmarkResult solverBenchmarkResult, Solution_[] extraProblems) {
        if (ConfigUtils.isEmptyCollection(this.inputSolutionFileList) && extraProblems.length == 0) {
            throw new IllegalArgumentException("The solverBenchmarkResult (" + solverBenchmarkResult.getName() + ") has no problems.\nMaybe configure at least 1 <inputSolutionFile> directly or indirectly by inheriting it.\nOr maybe pass at least one problem to " + PlannerBenchmarkFactory.class.getSimpleName() + ".buildPlannerBenchmark().");
        }
        ArrayList<ProblemProvider<Solution_>> problemProviderList = new ArrayList<ProblemProvider<Solution_>>(extraProblems.length + (this.inputSolutionFileList == null ? 0 : this.inputSolutionFileList.size()));
        SolutionDescriptor solutionDescriptor = solverBenchmarkResult.getSolverConfig().buildSolutionDescriptor(solverConfigContext);
        int extraProblemIndex = 0;
        for (Solution_ extraProblem : extraProblems) {
            if (extraProblem == null) {
                throw new IllegalStateException("The benchmark problem (" + extraProblem + ") is null.");
            }
            String problemName = "Problem_" + extraProblemIndex;
            problemProviderList.add(new InstanceProblemProvider<Solution_>(problemName, solutionDescriptor, extraProblem));
            ++extraProblemIndex;
        }
        if (ConfigUtils.isEmptyCollection(this.inputSolutionFileList)) {
            if (this.solutionFileIOClass != null || this.xStreamAnnotatedClassList != null) {
                throw new IllegalArgumentException("Cannot use solutionFileIOClass (" + this.solutionFileIOClass + ") or xStreamAnnotatedClassList (" + this.xStreamAnnotatedClassList + ") with an empty inputSolutionFileList (" + this.inputSolutionFileList + ").");
            }
        } else {
            SolutionFileIO<Solution_> solutionFileIO = this.buildSolutionFileIO();
            for (File inputSolutionFile : this.inputSolutionFileList) {
                if (!inputSolutionFile.exists()) {
                    throw new IllegalArgumentException("The inputSolutionFile (" + inputSolutionFile + ") does not exist.");
                }
                problemProviderList.add(new FileProblemProvider<Solution_>(solutionFileIO, inputSolutionFile));
            }
        }
        return problemProviderList;
    }

    private <Solution_> SolutionFileIO<Solution_> buildSolutionFileIO() {
        if (this.solutionFileIOClass != null && this.xStreamAnnotatedClassList != null) {
            throw new IllegalArgumentException("The solutionFileIOClass (" + this.solutionFileIOClass + ") and xStreamAnnotatedClassList (" + this.xStreamAnnotatedClassList + ") can be used together.");
        }
        if (this.solutionFileIOClass != null) {
            return (SolutionFileIO)ConfigUtils.newInstance((Object)((Object)this), (String)"solutionFileIOClass", this.solutionFileIOClass);
        }
        Class[] xStreamAnnotatedClasses = this.xStreamAnnotatedClassList != null ? this.xStreamAnnotatedClassList.toArray(new Class[0]) : new Class[]{};
        return new XStreamSolutionFileIO(xStreamAnnotatedClasses);
    }

    private <Solution_> ProblemBenchmarkResult<Solution_> buildProblemBenchmark(SolverConfigContext solverConfigContext, PlannerBenchmarkResult plannerBenchmarkResult, ProblemProvider<Solution_> problemProvider) {
        List<ProblemStatistic> problemStatisticList;
        ProblemBenchmarkResult<Solution_> problemBenchmarkResult = new ProblemBenchmarkResult<Solution_>(plannerBenchmarkResult);
        problemBenchmarkResult.setName(problemProvider.getProblemName());
        problemBenchmarkResult.setProblemProvider(problemProvider);
        problemBenchmarkResult.setWriteOutputSolutionEnabled(this.writeOutputSolutionEnabled == null ? false : this.writeOutputSolutionEnabled);
        if (BooleanUtils.isFalse((Boolean)this.problemStatisticEnabled)) {
            if (!ConfigUtils.isEmptyCollection(this.problemStatisticTypeList)) {
                throw new IllegalArgumentException("The problemStatisticEnabled (" + this.problemStatisticEnabled + ") and problemStatisticTypeList (" + this.problemStatisticTypeList + ") can be used together.");
            }
            problemStatisticList = Collections.emptyList();
        } else {
            List<ProblemStatisticType> problemStatisticTypeList_ = this.problemStatisticTypeList == null ? Collections.singletonList(ProblemStatisticType.BEST_SCORE) : this.problemStatisticTypeList;
            problemStatisticList = new ArrayList<ProblemStatistic>(problemStatisticTypeList_.size());
            for (ProblemStatisticType problemStatisticType : problemStatisticTypeList_) {
                problemStatisticList.add(problemStatisticType.buildProblemStatistic(problemBenchmarkResult));
            }
        }
        problemBenchmarkResult.setProblemStatisticList(problemStatisticList);
        problemBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        return problemBenchmarkResult;
    }

    private void buildSingleBenchmark(SolverConfigContext solverConfigContext, SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        SingleBenchmarkResult singleBenchmarkResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        this.buildSubSingleBenchmarks(singleBenchmarkResult, solverBenchmarkResult.getSubSingleCount());
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
            subSingleBenchmarkResult.setPureSubSingleStatisticList(new ArrayList<PureSubSingleStatistic>(this.singleStatisticTypeList == null ? 0 : this.singleStatisticTypeList.size()));
        }
        if (this.singleStatisticTypeList != null) {
            for (SingleStatisticType singleStatisticType : this.singleStatisticTypeList) {
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    subSingleBenchmarkResult.getPureSubSingleStatisticList().add(singleStatisticType.buildPureSubSingleStatistic(subSingleBenchmarkResult));
                }
            }
        }
        singleBenchmarkResult.initSubSingleStatisticMaps();
        solverBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
    }

    private void buildSubSingleBenchmarks(SingleBenchmarkResult parent, int subSingleCount) {
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(subSingleCount);
        for (int i = 0; i < subSingleCount; ++i) {
            SubSingleBenchmarkResult subSingleBenchmarkResult = new SubSingleBenchmarkResult(parent, i);
            subSingleBenchmarkResultList.add(subSingleBenchmarkResult);
        }
        parent.setSubSingleBenchmarkResultList(subSingleBenchmarkResultList);
    }

    public ProblemBenchmarksConfig inherit(ProblemBenchmarksConfig inheritedConfig) {
        this.solutionFileIOClass = (Class)ConfigUtils.inheritOverwritableProperty(this.solutionFileIOClass, inheritedConfig.getSolutionFileIOClass());
        this.xStreamAnnotatedClassList = ConfigUtils.inheritMergeableListProperty(this.xStreamAnnotatedClassList, inheritedConfig.getXStreamAnnotatedClassList());
        this.writeOutputSolutionEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.writeOutputSolutionEnabled, (Object)inheritedConfig.getWriteOutputSolutionEnabled());
        this.inputSolutionFileList = ConfigUtils.inheritMergeableListProperty(this.inputSolutionFileList, inheritedConfig.getInputSolutionFileList());
        this.problemStatisticEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.problemStatisticEnabled, (Object)inheritedConfig.getProblemStatisticEnabled());
        this.problemStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.problemStatisticTypeList, inheritedConfig.getProblemStatisticTypeList());
        this.singleStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.singleStatisticTypeList, inheritedConfig.getSingleStatisticTypeList());
        return this;
    }

    public ProblemBenchmarksConfig copyConfig() {
        return new ProblemBenchmarksConfig().inherit(this);
    }
}

