/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.persistence;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.persistence.PatientAdmissionScheduleDao;

public class PatientAdmissionScheduleExporter
extends AbstractTxtSolutionExporter<PatientAdmissionSchedule> {
    public static void main(String[] args) {
        new PatientAdmissionScheduleExporter().convertAll();
    }

    public PatientAdmissionScheduleExporter() {
        super(new PatientAdmissionScheduleDao());
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<PatientAdmissionSchedule> createTxtOutputBuilder() {
        return new PatientAdmissionScheduleOutputBuilder();
    }

    public static class PatientAdmissionScheduleOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder<PatientAdmissionSchedule> {
        @Override
        public void writeSolution() throws IOException {
            Collections.sort(((PatientAdmissionSchedule)this.solution).getBedDesignationList(), (a, b) -> new CompareToBuilder().append((Object)a.getAdmissionPart(), (Object)b.getAdmissionPart()).append((Object)a.getBed(), (Object)b.getBed()).append((Object)a.getId(), (Object)b.getId()).toComparison());
            for (Patient patient : ((PatientAdmissionSchedule)this.solution).getPatientList()) {
                this.bufferedWriter.write(Long.toString(patient.getId()));
                for (BedDesignation bedDesignation : ((PatientAdmissionSchedule)this.solution).getBedDesignationList()) {
                    if (!bedDesignation.getPatient().equals(patient)) continue;
                    for (int i = 0; i < bedDesignation.getAdmissionPart().getNightCount(); ++i) {
                        this.bufferedWriter.write(" " + Long.toString(bedDesignation.getBed().getId()));
                    }
                }
                this.bufferedWriter.write("\n");
            }
        }
    }
}

