/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.oauth;

import java.io.Serializable;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OpenIdPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 4404673070085740561L;
    private String identifier;
    private URL openIdProvider;
    private Map<String, List<String>> attributes;
    private String firstName;
    private String lastName;
    private String email;
    private String fullName;

    public OpenIdPrincipal(String identifier, URL openIdProvider, Map<String, List<String>> attributes) {
        this.identifier = identifier;
        this.openIdProvider = openIdProvider;
        this.attributes = attributes;
        this.process();
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public URL getOpenIdProvider() {
        return this.openIdProvider;
    }

    public Map<String, List<String>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String toString() {
        return "OpenIdPrincipal [identifier=" + this.identifier + ", openIdProvider=" + this.openIdProvider + ", attributes=" + this.attributes + "]";
    }

    private void process() {
        if (this.attributes != null) {
            List<String> values = this.attributes.get("ax_fullName");
            if (values != null && values.size() > 0) {
                this.fullName = values.get(0);
            } else {
                values = this.attributes.get("fullname");
                if (values != null && values.size() > 0) {
                    this.fullName = values.get(0);
                }
            }
            values = this.attributes.get("ax_firstName");
            if (values != null && values.size() > 0) {
                this.firstName = values.get(0);
            }
            if ((values = this.attributes.get("ax_lastName")) != null && values.size() > 0) {
                this.lastName = values.get(0);
            }
            if (this.fullName == null) {
                this.fullName = this.firstName + " " + this.lastName;
            }
            if ((values = this.attributes.get("ax_email")) != null && values.size() > 0) {
                this.email = values.get(0);
            }
        }
    }
}

