/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.tree.impl;

import java.io.File;
import org.rhq.augeas.AugeasProxy;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.node.AugeasRootNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeBuilder;
import org.rhq.augeas.tree.AugeasTreeException;
import org.rhq.augeas.tree.impl.AbstractAugeasTree;
import org.rhq.augeas.tree.impl.AugeasTreeLazy;
import org.rhq.augeas.tree.impl.AugeasTreeReal;

public class DefaultAugeasTreeBuilder
implements AugeasTreeBuilder {
    private static String AUGEAS_DATA_PATH = File.separatorChar + "files";

    @Override
    public AugeasTree buildTree(AugeasProxy component, AugeasConfiguration moduleConfig, String name, boolean lazy) throws AugeasTreeException {
        AugeasModuleConfig module = moduleConfig.getModuleByName(name);
        lazy = true;
        AbstractAugeasTree tree = true ? new AugeasTreeLazy(component.getAugeas(), module) : new AugeasTreeReal(component.getAugeas(), module);
        AugeasRootNode rootNode = new AugeasRootNode();
        for (String fileName : module.getConfigFiles()) {
            rootNode.addChildNode(tree.createNode(AUGEAS_DATA_PATH + File.separatorChar + fileName));
        }
        tree.setRootNode(rootNode);
        return tree;
    }
}

