/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.augeas;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.augeas.Augeas;
import net.augeas.AugeasException;
import net.augeas.jna.Aug;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.augeas.util.Glob;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.augeas.helper.AugeasNode;

public class AugeasConfigurationComponent<T extends ResourceComponent<?>>
implements ResourceComponent<T>,
ConfigurationFacet,
CreateChildResourceFacet,
DeleteResourceFacet {
    public static final String INCLUDE_GLOBS_PROP = "configurationFilesInclusionPatterns";
    public static final String EXCLUDE_GLOBS_PROP = "configurationFilesExclusionPatterns";
    public static final String RESOURCE_CONFIGURATION_ROOT_NODE_PROP = "resourceConfigurationRootNode";
    public static final String AUGEAS_MODULE_NAME_PROP = "augeasModuleName";
    public static final String AUGEAS_ROOT_PATH_PROP = "augeasRootPath";
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    public static final String DEFAULT_AUGEAS_ROOT_PATH = IS_WINDOWS ? "C:/" : "/";
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<T> resourceContext;
    private String resourceDescription;
    private List<String> includeGlobs;
    private List<String> excludeGlobs;
    private Augeas augeas;
    private AugeasNode resourceConfigRootNode;
    private String augeasRootPath;
    private String augeasLoadPath;

    protected String getAugeasRootPath() {
        return this.augeasRootPath;
    }

    protected String getAugeasLoadPath() {
        return this.augeasLoadPath;
    }

    public void start(ResourceContext<T> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.resourceDescription = this.resourceContext.getResourceType() + " Resource with key [" + this.resourceContext.getResourceKey() + "]";
        this.initGlobs();
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        this.augeasRootPath = pluginConfig.getSimpleValue(AUGEAS_ROOT_PATH_PROP, DEFAULT_AUGEAS_ROOT_PATH);
        this.log.debug((Object)("Augeas Root Path = \"" + this.augeasRootPath + "\""));
        this.augeasLoadPath = resourceContext.getDataDirectory().getAbsolutePath() + File.separator + "augeas-lenses";
        if (this.isAugeasAvailable()) {
            this.initAugeas();
        } else if (IS_WINDOWS) {
            this.log.debug((Object)"Augeas not found - this is expected, since Augeas is not currently available for Windows.");
        } else {
            this.log.warn((Object)"Augeas not found - if on Fedora or RHEL, `yum install augeas`.");
        }
    }

    public void stop() {
        this.close();
    }

    public AvailabilityType getAvailability() {
        for (File f : this.getConfigurationFiles()) {
            this.singleFileAvailabilityCheck(f);
        }
        return AvailabilityType.UP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        this.abortIfAugeasNotAvailable();
        try {
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            Configuration resourceConfig = new Configuration();
            resourceConfig.setNotes("Loaded from Augeas at " + new Date());
            Collection propDefs = resourceConfigDef.getPropertyDefinitions().values();
            for (PropertyDefinition propDef : propDefs) {
                this.loadProperty(propDef, (AbstractPropertyMap)resourceConfig, this.augeas, this.resourceConfigRootNode);
            }
            this.validateResourceConfiguration(new ConfigurationUpdateReport(resourceConfig));
            Configuration configuration = resourceConfig;
            return configuration;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStructuredConfiguration(Configuration config) throws Exception {
        this.abortIfAugeasNotAvailable();
        try {
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            Collection propDefs = resourceConfigDef.getPropertyDefinitions().values();
            for (PropertyDefinition propDef : propDefs) {
                this.setNode(propDef, (AbstractPropertyMap)config, this.augeas, this.resourceConfigRootNode);
            }
            this.saveConfigurationFiles();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            this.abortIfAugeasNotAvailable();
        }
        catch (Exception e) {
            report.setErrorMessage(e.getLocalizedMessage());
            return;
        }
        if (!this.validateResourceConfiguration(report)) {
            this.log.debug((Object)("Validation of updated Resource configuration for " + this.resourceDescription + " failed with the following errors: " + report.getErrorMessage()));
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            this.close();
            return;
        }
        try {
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            Configuration resourceConfig = report.getConfiguration();
            Collection propDefs = resourceConfigDef.getPropertyDefinitions().values();
            for (PropertyDefinition propDef : propDefs) {
                this.setNode(propDef, (AbstractPropertyMap)resourceConfig, this.augeas, this.resourceConfigRootNode);
            }
            this.saveConfigurationFiles();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        Configuration resourceConfig = report.getResourceConfiguration();
        ConfigurationDefinition resourceConfigDef = report.getResourceType().getResourceConfigurationDefinition();
        String rootPath = this.getChildResourceConfigurationRootPath(report.getResourceType(), report.getResourceConfiguration());
        this.initAugeas();
        try {
            AugeasNode rootNode = new AugeasNode(rootPath);
            if (this.augeas.exists(rootNode.getPath())) {
                report.setStatus(CreateResourceStatus.FAILURE);
                report.setErrorMessage("An Augeas node already exists with path " + rootPath);
                CreateResourceReport createResourceReport = report;
                return createResourceReport;
            }
            String rootLabel = this.getChildResourceConfigurationRootLabel(report.getResourceType(), report.getResourceConfiguration());
            this.augeas.set(rootNode.getPath(), rootLabel);
            Collection propDefs = resourceConfigDef.getPropertyDefinitions().values();
            for (PropertyDefinition propDef : propDefs) {
                this.setNode(propDef, (AbstractPropertyMap)resourceConfig, this.augeas, rootNode);
            }
            this.saveConfigurationFiles();
            report.setStatus(CreateResourceStatus.SUCCESS);
            CreateResourceReport createResourceReport = report;
            return createResourceReport;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        String rootPath = this.getResourceConfigurationRootPath();
        this.initAugeas();
        try {
            Augeas augeas = this.getAugeas();
            augeas.remove(rootPath);
            augeas.save();
        }
        finally {
            this.close();
        }
    }

    protected boolean validateResourceConfiguration(ConfigurationUpdateReport report) {
        return true;
    }

    protected AugeasNode getExistingChildNodeForListMemberPropertyMap(AugeasNode parentNode, PropertyDefinitionList propDefList, PropertyMap propMap) {
        String mapKey = this.getListMemberMapKey(propDefList);
        if (mapKey != null) {
            String existingChildNodeName = propMap.getSimple(mapKey).getStringValue();
            AugeasNode existingChildNode = new AugeasNode(parentNode, existingChildNodeName);
            return this.augeas.exists(existingChildNode.getPath()) ? existingChildNode : null;
        }
        return null;
    }

    @NotNull
    protected String getResourceConfigurationRootPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String rootPath = pluginConfig.getSimpleValue(RESOURCE_CONFIGURATION_ROOT_NODE_PROP, null);
        if (rootPath == null) {
            String includeGlobs = pluginConfig.getSimple(INCLUDE_GLOBS_PROP).getStringValue();
            if (includeGlobs.indexOf(124) != -1) {
                throw new IllegalStateException("Unable to determine resource configuration root Augeas path.");
            }
            rootPath = "/files" + includeGlobs;
        }
        return rootPath;
    }

    protected String getChildResourceConfigurationRootPath(ResourceType resourceType, Configuration resourceConfig) {
        throw new IllegalStateException("Class " + this.getClass().getName() + " does not override getChildResourceConfigurationRootPath() for " + resourceType + ".");
    }

    protected String getChildResourceConfigurationRootLabel(ResourceType resourceType, Configuration resourceConfig) {
        throw new IllegalStateException("Class " + this.getClass().getName() + " does not override getChildResourceConfigurationRootLabel() for " + resourceType + ".");
    }

    public ResourceContext<T> getResourceContext() {
        return this.resourceContext;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public List<File> getConfigurationFiles() {
        List<File> files = Glob.matchAll(new File(this.augeasRootPath), this.includeGlobs, Glob.ALPHABETICAL_COMPARATOR);
        Glob.excludeAll(files, this.excludeGlobs);
        return files;
    }

    public Augeas getAugeas() {
        if (this.augeas == null) {
            this.initAugeas();
        }
        return this.augeas;
    }

    protected void setupAugeasModules(Augeas augeas) {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String augeasModuleName = pluginConfig.getSimpleValue(AUGEAS_MODULE_NAME_PROP, null);
        if (augeasModuleName == null) {
            throw new IllegalStateException("Plugin config property 'augeasModuleName' is required.");
        }
        augeas.set("/augeas/load/" + augeasModuleName + "/lens", augeasModuleName + ".lns");
        int idx = 1;
        for (String incl : this.includeGlobs) {
            augeas.set("/augeas/load/" + augeasModuleName + "/incl[" + idx++ + "]", incl);
        }
        idx = 1;
        for (String excl : this.excludeGlobs) {
            augeas.set("/augeas/load/" + augeasModuleName + "/excl[" + idx++ + "]", excl);
        }
    }

    protected Augeas createAugeas() {
        Augeas augeas;
        try {
            augeas = new Augeas(this.augeasRootPath, this.augeasLoadPath, Augeas.NO_MODL_AUTOLOAD);
            this.setupAugeasModules(augeas);
            this.checkModuleErrors(augeas);
        }
        catch (RuntimeException e) {
            augeas = null;
            this.log.error((Object)"Failed to initialize Augeas Java API.", (Throwable)e);
        }
        return augeas;
    }

    protected boolean isAugeasAvailable() {
        Aug aug;
        try {
            aug = Aug.INSTANCE;
        }
        catch (Error e) {
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Aug JNA object: " + aug));
        }
        return true;
    }

    protected String getAugeasPathRelativeToParent(PropertyDefinition propDef, AugeasNode parentNode, Augeas augeas) {
        return propDef.getName();
    }

    protected void loadProperty(PropertyDefinition propDef, AbstractPropertyMap parentPropMap, Augeas augeas, AugeasNode parentNode) {
        Property prop;
        AugeasNode node;
        String propName = this.getAugeasPathRelativeToParent(propDef, parentNode, augeas);
        AugeasNode augeasNode = node = propName.equals(".") ? parentNode : new AugeasNode(parentNode, propName);
        if (propDef instanceof PropertyDefinitionSimple) {
            prop = this.createPropertySimple((PropertyDefinitionSimple)propDef, augeas, node);
        } else if (propDef instanceof PropertyDefinitionMap) {
            prop = this.createPropertyMap((PropertyDefinitionMap)propDef, augeas, node);
        } else if (propDef instanceof PropertyDefinitionList) {
            prop = this.createPropertyList((PropertyDefinitionList)propDef, augeas, node);
        } else {
            throw new IllegalStateException("Unsupported PropertyDefinition subclass: " + propDef.getClass().getName());
        }
        if (prop != null) {
            parentPropMap.put(prop);
        }
    }

    protected Object toPropertyValue(PropertyDefinitionSimple propDefSimple, Augeas augeas, AugeasNode node) {
        return augeas.get(node.getPath());
    }

    protected Property createPropertySimple(PropertyDefinitionSimple propDefSimple, Augeas augeas, AugeasNode node) {
        Object value;
        if (propDefSimple.getType() == PropertySimpleType.LONG_STRING) {
            List childPaths = augeas.match(node.getPath());
            if (childPaths.isEmpty()) {
                return null;
            }
            StringBuilder propValue = new StringBuilder();
            for (String childPath : childPaths) {
                String childValue = augeas.get(childPath);
                propValue.append(childValue).append("\n");
            }
            propValue.deleteCharAt(propValue.length() - 1);
            value = propValue.toString();
        } else {
            value = this.toPropertyValue(propDefSimple, augeas, node);
        }
        return new PropertySimple(propDefSimple.getName(), value);
    }

    protected PropertyMap createPropertyMap(PropertyDefinitionMap propDefMap, Augeas augeas, AugeasNode node) {
        PropertyMap propMap = new PropertyMap(propDefMap.getName());
        this.populatePropertyMap(propDefMap, propMap, augeas, node);
        return propMap;
    }

    protected Property createPropertyList(PropertyDefinitionList propDefList, Augeas augeas, AugeasNode node) {
        PropertyDefinition listMemberPropDef = propDefList.getMemberDefinition();
        if (!(listMemberPropDef instanceof PropertyDefinitionMap)) {
            throw new IllegalArgumentException("Invalid Resource ConfigurationDefinition - only lists of maps are supported.");
        }
        PropertyDefinitionMap listMemberPropDefMap = (PropertyDefinitionMap)listMemberPropDef;
        PropertyList propList = new PropertyList(propDefList.getName());
        String mapKey = this.getListMemberMapKey(propDefList);
        String mapPath = this.getAugeasPathRelativeToParent((PropertyDefinition)listMemberPropDefMap, node, augeas);
        String listMemberPathsExpression = node.getPath() + '/' + mapPath;
        List listMemberPaths = augeas.match(listMemberPathsExpression);
        for (String listMemberPath : listMemberPaths) {
            AugeasNode listMemberNode = new AugeasNode(listMemberPath);
            PropertyMap listMemberPropMap = new PropertyMap(listMemberPropDefMap.getName());
            propList.add((Property)listMemberPropMap);
            if (mapKey != null) {
                PropertySimple keyProp = new PropertySimple(mapKey, (Object)listMemberNode.getName());
                listMemberPropMap.put((Property)keyProp);
            }
            this.populatePropertyMap(listMemberPropDefMap, listMemberPropMap, augeas, listMemberNode);
        }
        return propList;
    }

    protected void populatePropertyMap(PropertyDefinitionMap propDefMap, PropertyMap propMap, Augeas augeas, AugeasNode mapNode) {
        for (PropertyDefinition mapEntryPropDef : propDefMap.getPropertyDefinitions()) {
            this.loadProperty(mapEntryPropDef, (AbstractPropertyMap)propMap, augeas, mapNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setNode(PropertyDefinition propDef, AbstractPropertyMap parentPropMap, Augeas augeas, AugeasNode parentNode) {
        AugeasNode node;
        String propName = this.getAugeasPathRelativeToParent(propDef, parentNode, augeas);
        AugeasNode augeasNode = node = propName.equals(".") ? parentNode : new AugeasNode(parentNode, propName);
        if (this.isPropertyDefined(propDef, parentPropMap)) {
            if (propDef instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple propDefSimple = (PropertyDefinitionSimple)propDef;
                PropertySimple propSimple = parentPropMap.getSimple(propDefSimple.getName());
                this.setNodeFromPropertySimple(augeas, node, propDefSimple, propSimple);
                return;
            } else if (propDef instanceof PropertyDefinitionMap) {
                PropertyDefinitionMap propDefMap = (PropertyDefinitionMap)propDef;
                PropertyMap propMap = parentPropMap.getMap(propDefMap.getName());
                this.setNodeFromPropertyMap(propDefMap, propMap, augeas, node);
                return;
            } else {
                if (!(propDef instanceof PropertyDefinitionList)) throw new IllegalStateException("Unsupported PropertyDefinition subclass: " + propDef.getClass().getName());
                PropertyDefinitionList propDefList = (PropertyDefinitionList)propDef;
                PropertyList propList = parentPropMap.getList(propDefList.getName());
                this.setNodeFromPropertyList(propDefList, propList, augeas, node);
            }
            return;
        } else {
            this.removeNodeIfItExists(augeas, node);
        }
    }

    protected String toNodeValue(Augeas augeas, AugeasNode node, PropertyDefinitionSimple propDefSimple, PropertySimple propSimple) {
        return propSimple.getStringValue();
    }

    protected String getNodeInsertionPoint(Augeas augeas, AugeasNode node, PropertyDefinitionSimple propDefSimple, PropertySimple propSimple) {
        return String.format("%s/*[following-sibling::*[1]=%s[1]]", node.getParent().getPath(), node.getPath());
    }

    protected void setNodeFromPropertySimple(Augeas augeas, AugeasNode node, PropertyDefinitionSimple propDefSimple, PropertySimple propSimple) {
        String value = this.toNodeValue(augeas, node, propDefSimple, propSimple);
        if (propDefSimple.getType() == PropertySimpleType.LONG_STRING) {
            String varName = "path";
            String nodeExpression = this.getNodeInsertionPoint(augeas, node, propDefSimple, propSimple);
            augeas.defineNode(varName, nodeExpression, null);
            augeas.remove(node.getPath());
            String[] tokens = value.trim().split("\\s+");
            for (int i = tokens.length; i > 0; --i) {
                String itemValue = tokens[i - 1];
                if (itemValue == null || itemValue.trim().length() == 0) continue;
                augeas.insert("$" + varName, node.getName(), false);
                augeas.set(node.getPath() + "[1]", itemValue);
            }
        } else {
            augeas.set(node.getPath(), value);
        }
    }

    protected void setNodeFromPropertyMap(PropertyDefinitionMap propDefMap, PropertyMap propMap, Augeas augeas, AugeasNode mapNode) {
        for (PropertyDefinition mapEntryPropDef : propDefMap.getPropertyDefinitions()) {
            this.setNode(mapEntryPropDef, (AbstractPropertyMap)propMap, augeas, mapNode);
        }
    }

    protected void setNodeFromPropertyList(PropertyDefinitionList propDefList, PropertyList propList, Augeas augeas, AugeasNode listNode) {
        PropertyDefinition listMemberPropDef = propDefList.getMemberDefinition();
        if (!(listMemberPropDef instanceof PropertyDefinitionMap)) {
            throw new IllegalArgumentException("Invalid Resource ConfigurationDefinition - only lists of maps are supported.");
        }
        PropertyDefinitionMap listMemberPropDefMap = (PropertyDefinitionMap)listMemberPropDef;
        int listIndex = 0;
        String listMemberPropDefMapPath = this.getAugeasPathRelativeToParent((PropertyDefinition)listMemberPropDefMap, listNode, augeas);
        List existingListMemberPaths = augeas.match(listNode.getPath() + '/' + listMemberPropDefMapPath);
        ArrayList<AugeasNode> existingListMemberNodes = new ArrayList<AugeasNode>();
        for (String existingListMemberPath : existingListMemberPaths) {
            existingListMemberNodes.add(new AugeasNode(existingListMemberPath));
        }
        HashSet<AugeasNode> updatedListMemberNodes = new HashSet<AugeasNode>();
        for (Property listMemberProp : propList.getList()) {
            PropertyMap listMemberPropMap = (PropertyMap)listMemberProp;
            AugeasNode memberNodeToUpdate = this.getExistingChildNodeForListMemberPropertyMap(listNode, propDefList, listMemberPropMap);
            if (memberNodeToUpdate != null) {
                updatedListMemberNodes.add(memberNodeToUpdate);
            } else {
                AugeasNode basePathNode = this.getNewListMemberNode(listNode, listMemberPropDefMap, listIndex);
                String var = "prop" + listIndex;
                String bpath = basePathNode.getPath();
                augeas.defineNode(var, bpath, null);
                memberNodeToUpdate = new AugeasNode("$" + var);
                ++listIndex;
            }
            this.setNodeFromPropertyMap(listMemberPropDefMap, listMemberPropMap, augeas, memberNodeToUpdate);
        }
        for (AugeasNode existingListMemberNode : existingListMemberNodes) {
            if (updatedListMemberNodes.contains(existingListMemberNode)) continue;
            augeas.remove(existingListMemberNode.getPath());
        }
    }

    protected AugeasNode getNewListMemberNode(AugeasNode listNode, PropertyDefinitionMap listMemberPropDefMap, int listIndex) {
        return new AugeasNode(listNode, this.getAugeasPathRelativeToParent((PropertyDefinition)listMemberPropDefMap, listNode, this.getAugeas()) + "[" + listIndex + "]");
    }

    private boolean isPropertyDefined(PropertyDefinition propDef, AbstractPropertyMap parentPropMap) {
        Property prop = parentPropMap.get(propDef.getName());
        if (prop == null) {
            return false;
        }
        return !(prop instanceof PropertySimple) || ((PropertySimple)prop).getStringValue() != null;
    }

    private void removeNodeIfItExists(Augeas augeas, AugeasNode node) {
        if (augeas.exists(node.getPath())) {
            this.log.debug((Object)("Removing node " + node + " from Augeas tree..."));
            augeas.remove(node.getPath());
        }
    }

    @Nullable
    private String getListMemberMapKey(PropertyDefinitionList propDefList) {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertyMap mapKeyNames = pluginConfig.getMap("listMemberMapKeyNames");
        if (mapKeyNames == null) {
            return null;
        }
        String listName = propDefList.getName();
        return mapKeyNames.getSimpleValue(listName, null);
    }

    private void saveConfigurationFiles() {
        try {
            this.augeas.save();
        }
        catch (AugeasException e) {
            throw new RuntimeException(this.summarizeAugeasError(this.augeas), e);
        }
    }

    private void initGlobs() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertySimple includes = pluginConfig.getSimple(INCLUDE_GLOBS_PROP);
        PropertySimple excludes = pluginConfig.getSimple(EXCLUDE_GLOBS_PROP);
        this.includeGlobs = new ArrayList<String>();
        this.excludeGlobs = new ArrayList<String>();
        this.includeGlobs.addAll(Arrays.asList(includes.getStringValue().split("\\s*\\|\\s*")));
        if (excludes != null && excludes.getStringValue() != null) {
            this.excludeGlobs.addAll(Arrays.asList(excludes.getStringValue().split("\\s*\\|\\s*")));
        }
    }

    private void singleFileAvailabilityCheck(File f) {
        if (!f.isAbsolute()) {
            throw new InvalidPluginConfigurationException("Path '" + f.getPath() + "' is not an absolute path.");
        }
        if (!f.exists()) {
            throw new InvalidPluginConfigurationException("File '" + f.getPath() + "' does not exist.");
        }
        if (f.isDirectory()) {
            throw new InvalidPluginConfigurationException("Path '" + f.getPath() + "' is a directory, not a regular file.");
        }
    }

    protected String summarizeAugeasError(Augeas augeas) {
        StringBuilder summary = new StringBuilder();
        String metadataNodePrefix = "/augeas/files";
        for (String glob : this.includeGlobs) {
            if (glob.startsWith(AugeasNode.SEPARATOR)) {
                glob = glob.substring(1);
            }
            AugeasNode metadataNode = new AugeasNode(metadataNodePrefix, glob);
            AugeasNode errorNode = new AugeasNode(metadataNode, "error");
            List nodePaths = augeas.match(errorNode.getPath() + "/*");
            for (String path : nodePaths) {
                String error = augeas.get(path);
                summary.append("File \"").append(path.substring(metadataNodePrefix.length(), path.length())).append("\":\n").append(error).append("\n");
            }
        }
        return summary.toString();
    }

    protected void initAugeas() {
        if (this.augeas != null) {
            try {
                this.augeas.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.augeas = null;
        }
        this.augeas = this.createAugeas();
        this.augeas.load();
        this.checkModuleErrors(this.augeas);
        String resourceConfigRootPath = this.getResourceConfigurationRootPath();
        this.resourceConfigRootNode = resourceConfigRootPath.indexOf(47) != 0 ? new AugeasNode("/files/", resourceConfigRootPath) : new AugeasNode(resourceConfigRootPath);
        this.log.debug((Object)("Resource Config Root Node = \"" + this.resourceConfigRootNode + "\""));
    }

    private void abortIfAugeasNotAvailable() throws Exception {
        if (this.getAugeas() == null) {
            if (this.isAugeasAvailable()) {
                this.initAugeas();
                if (this.getAugeas() == null) {
                    throw new Exception("Failed to initialize Augeas Java API.");
                }
            } else {
                String message = IS_WINDOWS ? "Configuration of " + this.getResourceContext().getResourceType().getName() + " Resources is not supported on Windows." : "Configuration of " + this.getResourceContext().getResourceType().getName() + " Resources requires that the Augeas shared library be installed on the Agent system." + " If on Fedora or RHEL, `yum install augeas`.";
                throw new Exception(message);
            }
        }
    }

    private void checkModuleErrors(Augeas augeas) {
        List errors = augeas.match("/augeas/load//error");
        if (errors != null && errors.size() > 0) {
            StringBuilder errorMessage = new StringBuilder();
            for (String nodePath : errors) {
                AugeasNode node = new AugeasNode(nodePath);
                String moduleName = node.getParent().getName();
                String errorText = augeas.get(nodePath);
                errorMessage.append("Module '").append(moduleName).append("' failed with the following errors:\n");
                errorMessage.append(errorText);
                errorMessage.append("\n\n");
            }
            throw new IllegalStateException("Augeas modules didn't load cleanly.\n" + errorMessage);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.augeas != null) {
            try {
                this.augeas.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.augeas = null;
        }
    }
}

