/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.augeas.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.augeas.jna.Aug;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.configuration.ConfigurationManager;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.plugin.FileSystemPluginFinder;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.file.FileUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractAugeasConfigurationComponentTest {
    public static final String TEST_GROUP = "linux-config";
    private static final File ITEST_DIR = new File("target/itest");
    private static final long ONE_WEEK_IN_SECONDS = 86400L;
    protected static final boolean IS_WINDOWS = File.separatorChar == '\\';
    protected static final File AUGEAS_ROOT;
    private final Log log = LogFactory.getLog(this.getClass());

    @BeforeClass(groups={"linux-config"})
    public void start() {
        if (!this.isResourceConfigSupported()) {
            String message = IS_WINDOWS ? "Augeas is not available on Windows. Augeas-based configuration functionality will *not* be tested." : "Augeas not found. If on Fedora or RHEL, `yum install augeas`. Augeas-based configuration functionality will *not* be tested.";
            System.out.println(message);
        }
        try {
            PluginContainerConfiguration pcConfig = this.createPluginContainerConfiguration();
            PluginContainer.getInstance().setConfiguration(pcConfig);
            System.out.println("Starting plugin container...");
            PluginContainer pluginContainer = PluginContainer.getInstance();
            pluginContainer.initialize();
            Set pluginNames = pluginContainer.getPluginManager().getMetadataManager().getPluginNames();
            System.out.println("Plugin container started with the following plugins: " + pluginNames);
            System.out.println("Updating Augeas root in default plugin config...");
            boolean deleteRoot = true;
            for (ResourceType resourceType : AbstractAugeasConfigurationComponentTest.getResourceTypes(this.getPluginName())) {
                ConfigurationDefinition pluginConfigDef = resourceType.getPluginConfigurationDefinition();
                ConfigurationTemplate defaultPluginConfigTemplate = pluginConfigDef.getDefaultTemplate();
                Configuration defaultPluginConfig = defaultPluginConfigTemplate.getConfiguration();
                this.tweakDefaultPluginConfig(defaultPluginConfig);
                this.resetConfigFiles(defaultPluginConfig, deleteRoot);
                deleteRoot = false;
            }
            InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
            System.out.println("Executing server discovery scan...");
            inventoryManager.executeServerScanImmediately();
            System.out.println("Executing service discovery scan...");
            inventoryManager.executeServiceScanImmediately();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Failed to initialize the plugin container.", (Throwable)e);
        }
    }

    @AfterMethod(groups={"linux-config"})
    public void resetConfigFiles() throws IOException {
        boolean deleteRoot = true;
        for (Resource res : this.getResources()) {
            this.resetConfigFiles(res.getPluginConfiguration(), deleteRoot);
            deleteRoot = false;
        }
    }

    @Test(groups={"linux-config"})
    public void testResourceConfigLoad() throws Exception {
        block4: {
            ConfigurationManager configurationManager = PluginContainer.getInstance().getConfigurationManager();
            try {
                for (Resource resource : this.getResources()) {
                    Configuration resourceConfig = configurationManager.loadResourceConfiguration(resource.getId());
                    Configuration expectedResourceConfig = this.getExpectedResourceConfig();
                    assert (resourceConfig.equals((Object)expectedResourceConfig)) : "Unexpected Resource configuration - \nExpected:\n\t" + expectedResourceConfig.toString(true) + "\nActual:\n\t" + resourceConfig.toString(true);
                }
            }
            catch (PluginContainerException e) {
                if (!this.isResourceConfigSupported()) break block4;
                throw e;
            }
        }
    }

    @Test(groups={"linux-config"})
    public void testResourceConfigUpdate() throws Exception {
        ConfigurationManager configurationManager = PluginContainer.getInstance().getConfigurationManager();
        for (Resource resource : this.getResources()) {
            Configuration updatedResourceConfig = this.getUpdatedResourceConfig();
            ConfigurationUpdateRequest updateRequest = new ConfigurationUpdateRequest(0, updatedResourceConfig, resource.getId());
            configurationManager.executeUpdateResourceConfigurationImmediately(updateRequest);
            if (!this.isResourceConfigSupported()) continue;
            Configuration resourceConfig = configurationManager.loadResourceConfiguration(resource.getId());
            assert (resourceConfig.equals((Object)updatedResourceConfig)) : "Unexpected Resource configuration - \nExpected:\n\t" + updatedResourceConfig.toString(true) + "\nActual:\n\t" + resourceConfig.toString(true);
        }
    }

    @AfterClass(groups={"linux-config"})
    public void stop() {
        this.deleteAugeasRootDir();
        System.out.println("Stopping plugin container...");
        PluginContainer.getInstance().shutdown();
        System.out.println("Plugin container stopped.");
    }

    protected abstract String getPluginName();

    protected abstract String getResourceTypeName();

    protected abstract Configuration getExpectedResourceConfig();

    protected abstract Configuration getUpdatedResourceConfig();

    protected PluginContainerConfiguration createPluginContainerConfiguration() throws IOException {
        PluginContainerConfiguration pcConfig = new PluginContainerConfiguration();
        File pluginsDir = new File(ITEST_DIR, "plugins");
        pcConfig.setPluginFinder((PluginFinder)new FileSystemPluginFinder(pluginsDir));
        pcConfig.setPluginDirectory(pluginsDir);
        pcConfig.setInsideAgent(false);
        pcConfig.setCreateResourceClassloaders(true);
        pcConfig.setServerDiscoveryInitialDelay(86400L);
        pcConfig.setServiceDiscoveryInitialDelay(86400L);
        pcConfig.setAvailabilityScanInitialDelay(86400L);
        pcConfig.setConfigurationDiscoveryInitialDelay(86400L);
        pcConfig.setContentDiscoveryInitialDelay(86400L);
        File tmpDir = new File(ITEST_DIR, "tmp");
        tmpDir.mkdirs();
        if (!tmpDir.isDirectory() || !tmpDir.canWrite()) {
            throw new IOException("Failed to create temporary directory (" + tmpDir + ").");
        }
        pcConfig.setTemporaryDirectory(tmpDir);
        File dataDir = new File(ITEST_DIR, "plugin-data");
        dataDir.mkdirs();
        if (!dataDir.isDirectory() || !dataDir.canWrite()) {
            throw new IOException("Failed to create data directory (" + dataDir + ").");
        }
        pcConfig.setDataDirectory(dataDir);
        return pcConfig;
    }

    protected static Set<ResourceType> getResourceTypes(String pluginName) {
        HashSet<ResourceType> ret = new HashSet<ResourceType>();
        PluginManager pluginManager = PluginContainer.getInstance().getPluginManager();
        PluginMetadataManager pluginMetadataManager = pluginManager.getMetadataManager();
        for (ResourceType res : pluginMetadataManager.getAllTypes()) {
            if (!pluginName.equals(res.getPlugin())) continue;
            ret.add(res);
        }
        return ret;
    }

    protected static ResourceType getResourceType(String resourceTypeName, String pluginName) {
        PluginManager pluginManager = PluginContainer.getInstance().getPluginManager();
        PluginMetadataManager pluginMetadataManager = pluginManager.getMetadataManager();
        return pluginMetadataManager.getType(resourceTypeName, pluginName);
    }

    protected final ResourceType getResourceType() {
        return AbstractAugeasConfigurationComponentTest.getResourceType(this.getResourceTypeName(), this.getPluginName());
    }

    protected Set<Resource> getResources() {
        InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
        ResourceType resourceType = this.getResourceType();
        Set resources = inventoryManager.getResourcesWithType(resourceType);
        return resources;
    }

    protected void resetConfigFiles(Configuration pluginConfig, boolean deleteRoot) throws IOException {
        if (deleteRoot) {
            this.deleteAugeasRootDir();
        }
        AUGEAS_ROOT.mkdirs();
        String includes = pluginConfig.getSimpleValue("configurationFilesInclusionPatterns", null);
        if (includes != null) {
            ArrayList<String> includeGlobs = new ArrayList<String>();
            includeGlobs.addAll(Arrays.asList(includes.split("\\s*\\|\\s*")));
            for (String includeGlob : includeGlobs) {
                InputStream inputStream;
                String resourcePath;
                if (IS_WINDOWS) {
                    resourcePath = includeGlob.replace('\\', '/');
                    int colonIndex = resourcePath.indexOf(58);
                    if (colonIndex != -1) {
                        resourcePath = resourcePath.substring(colonIndex + 1);
                    }
                } else {
                    resourcePath = includeGlob;
                }
                if ((inputStream = this.getClass().getResourceAsStream(resourcePath)) == null) continue;
                File outputFile = new File(AUGEAS_ROOT, resourcePath);
                outputFile.getParentFile().mkdirs();
                FileUtil.writeFile((InputStream)inputStream, (File)outputFile);
            }
        }
    }

    protected boolean isResourceConfigSupported() {
        return this.isAugeasAvailable();
    }

    protected void tweakDefaultPluginConfig(Configuration defaultPluginConfig) {
        PropertySimple rootPathProp = new PropertySimple("augeasRootPath", (Object)AUGEAS_ROOT);
        defaultPluginConfig.put((Property)rootPathProp);
    }

    private boolean isAugeasAvailable() {
        try {
            Aug aug = Aug.INSTANCE;
            return true;
        }
        catch (Error e) {
            return false;
        }
    }

    private void deleteAugeasRootDir() {
        try {
            FileUtils.purge((File)AUGEAS_ROOT, (boolean)true);
        }
        catch (IOException e) {
            this.log.warn((Object)("Failed to delete Augeas root dir (" + AUGEAS_ROOT + ")."));
        }
    }

    static {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirPath);
        AUGEAS_ROOT = new File(tmpDir, "rhq-itest-augeas-root-path");
    }
}

