/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.drift;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.common.drift.ChangeSetReader;
import org.rhq.common.drift.ChangeSetReaderException;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.domain.drift.DriftChangeSetCategory;

public class ChangeSetReaderImpl
implements ChangeSetReader {
    private Log log = LogFactory.getLog(ChangeSetReaderImpl.class);
    private BufferedReader reader;
    private File metaDataFile;
    private Headers headers;
    private boolean closeStream;

    public ChangeSetReaderImpl(File metaDataFile) throws ChangeSetReaderException {
        try {
            this.metaDataFile = metaDataFile;
            this.reader = new BufferedReader(new FileReader(this.metaDataFile));
            this.readHeaders();
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to read headers from " + metaDataFile.getAbsolutePath() + ": " + e.getMessage()));
            throw new ChangeSetReaderException("Unable to read headers from " + metaDataFile.getAbsolutePath(), e);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)("Unable to read headers from " + metaDataFile.getAbsolutePath() + ": " + e.getMessage()));
            throw new ChangeSetReaderException("Unable to read headers from " + metaDataFile.getAbsolutePath(), e);
        }
    }

    public ChangeSetReaderImpl(Reader metaDataFile) throws Exception {
        this(metaDataFile, false);
    }

    public ChangeSetReaderImpl(Reader metaDataFile, boolean closeStream) throws Exception {
        this.reader = new BufferedReader(metaDataFile);
        this.readHeaders();
        this.closeStream = closeStream;
    }

    private void readHeaders() throws IOException {
        this.headers = new Headers();
        try {
            this.headers.setResourceId(Integer.parseInt(this.reader.readLine()));
            this.headers.setDriftDefinitionId(Integer.parseInt(this.reader.readLine()));
            this.headers.setDriftDefinitionName(this.reader.readLine());
            this.headers.setBasedir(this.reader.readLine());
            this.headers.setType(DriftChangeSetCategory.fromCode((String)this.reader.readLine()));
            this.headers.setVersion(Integer.parseInt(this.reader.readLine()));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Invalid changeset headers, could not parse: ", t);
        }
    }

    @Override
    public Headers getHeaders() throws ChangeSetReaderException {
        return this.headers;
    }

    @Override
    public FileEntry read() throws ChangeSetReaderException {
        try {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            if (line.charAt(0) == 'A') {
                int fileSizeEndIndex = line.indexOf(32, 2);
                long size = Long.parseLong(line.substring(2, fileSizeEndIndex));
                int lastModifiedEndIndex = line.indexOf(32, fileSizeEndIndex + 1);
                long lastModified = Long.parseLong(line.substring(fileSizeEndIndex + 1, lastModifiedEndIndex));
                int shaEndIndex = lastModifiedEndIndex + 65;
                String sha = line.substring(lastModifiedEndIndex + 1, shaEndIndex);
                String fileName = line.substring(shaEndIndex + 3);
                return FileEntry.addedFileEntry(fileName, sha, lastModified, size);
            }
            if (line.charAt(0) == 'C') {
                int fileSizeEndIndex = line.indexOf(32, 2);
                long size = Long.parseLong(line.substring(2, fileSizeEndIndex));
                int lastModifiedEndIndex = line.indexOf(32, fileSizeEndIndex + 1);
                long lastModified = Long.parseLong(line.substring(fileSizeEndIndex + 1, lastModifiedEndIndex));
                int newShaIndex = lastModifiedEndIndex + 65;
                String newSha = line.substring(lastModifiedEndIndex + 1, newShaIndex);
                int oldShaIndex = newShaIndex + 65;
                String oldSha = line.substring(newShaIndex + 1, oldShaIndex);
                String fileName = line.substring(oldShaIndex + 1);
                return FileEntry.changedFileEntry(fileName, oldSha, newSha, lastModified, size);
            }
            if (line.charAt(0) == 'R') {
                String sha = line.substring(10, 74);
                String fileName = line.substring(75);
                return FileEntry.removedFileEntry(fileName, sha);
            }
            this.log.error((Object)("An error occurred while parsing " + this.metaDataFile.getAbsolutePath() + ": " + line.charAt(0) + " is not a recognized drift change set category code."));
            throw new ChangeSetReaderException(line.charAt(0) + " is not a recognized drift change set category code.");
        }
        catch (IOException e) {
            this.log.error((Object)("An error ocurred while parsing " + this.metaDataFile.getAbsolutePath() + ": " + e.getMessage()));
            throw new ChangeSetReaderException("An error ocurred while parsing " + this.metaDataFile.getAbsolutePath(), e);
        }
    }

    @Override
    public void close() throws ChangeSetReaderException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.log.warn((Object)("An error ocurred while trying to close " + this.metaDataFile.getAbsolutePath() + ": " + e.getMessage()));
            throw new ChangeSetReaderException("An error ocurred while trying to close " + this.metaDataFile.getAbsolutePath(), e);
        }
    }

    @Override
    public Iterator<FileEntry> iterator() {
        return new Iterator<FileEntry>(){
            private FileEntry next;
            {
                try {
                    this.next = ChangeSetReaderImpl.this.read();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create iterator: " + e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public FileEntry next() {
                try {
                    FileEntry previous = this.next;
                    this.next = ChangeSetReaderImpl.this.read();
                    if (this.next == null && ChangeSetReaderImpl.this.closeStream) {
                        ChangeSetReaderImpl.this.close();
                    }
                    return previous;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to get next " + FileEntry.class.getName() + ": " + e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

