/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud.util;

import org.mockito.Mockito;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.cloud.StorageNodeConfigurationComposite;
import org.rhq.enterprise.server.cloud.util.StorageNodeConfigurationUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StorageNodeConfigurationUtilTest {
    @Test
    public void testConfigurationSync() throws Exception {
        StorageNode mockStorageNode = (StorageNode)Mockito.mock(StorageNode.class);
        StorageNodeConfigurationComposite oldConfig = new StorageNodeConfigurationComposite(mockStorageNode);
        StorageNodeConfigurationComposite newConfig = new StorageNodeConfigurationComposite(mockStorageNode);
        String oldLogLocationValue = "oldLogLocation";
        oldConfig.setCommitLogLocation(oldLogLocationValue);
        String heapNewSize = "384m";
        newConfig.setHeapNewSize(heapNewSize);
        String newCacheLocationValue = "newCacheLocation";
        String oldCacheLocationValue = "oldCacheLocation";
        newConfig.setSavedCachesLocation(newCacheLocationValue);
        oldConfig.setSavedCachesLocation(oldCacheLocationValue);
        StorageNodeConfigurationUtil.syncConfigs((StorageNodeConfigurationComposite)newConfig, (StorageNodeConfigurationComposite)oldConfig);
        Assert.assertEquals((String)newConfig.getCommitLogLocation(), (String)oldLogLocationValue);
        Assert.assertEquals((String)newConfig.getHeapNewSize(), (String)heapNewSize);
        Assert.assertNull((Object)oldConfig.getHeapNewSize());
        Assert.assertEquals((String)newConfig.getSavedCachesLocation(), (String)newCacheLocationValue);
        Assert.assertEquals((String)oldConfig.getSavedCachesLocation(), (String)oldCacheLocationValue);
    }
}

