/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.util.Properties;
import org.rhq.core.clientapi.server.core.AgentVersion;
import org.rhq.enterprise.server.core.AgentManagerBean;
import org.testng.annotations.Test;

@Test
public class AgentSupportedBuildTest {
    private String agentLatestBuild;
    private String agentLatestVersion;
    private String supportedBuildsRegex;
    private AgentManagerBean agentManager = new AgentManagerStub();

    public void testLatestAgentBuildCheck() {
        AgentVersion agentVersionInfo = this.setLatestAgentVersionAndBuildToCheck("1.0.GA", "cafebabe0", "1.0.GA", "cafebabe0");
        assert (this.agentManager.isAgentVersionSupported(agentVersionInfo).isSupported());
        agentVersionInfo = this.setLatestAgentVersionAndBuildToCheck("1.0.GA", "cafebabe0", "1.0.RC1", "cafebabe1");
        assert (!this.agentManager.isAgentVersionSupported(agentVersionInfo).isSupported());
        agentVersionInfo = this.setLatestAgentVersionAndBuildToCheck("1.0.GA", "nocafe", "2.0.GA", "cafebabe2");
        assert (!this.agentManager.isAgentVersionSupported(agentVersionInfo).isSupported());
    }

    public void testSupportedBuildsCheck() {
        String regex = "1.0.GA";
        this.checkOK(regex, "1.0.GA");
        this.checkFail(regex, "1.0.RC1");
        this.checkFail(regex, "2.0.GA");
        regex = "3.2.0.(GA|CP[12345])";
        this.checkOK(regex, "3.2.0.GA");
        this.checkOK(regex, "3.2.0.CP1");
        this.checkOK(regex, "3.2.0.CP5");
        this.checkFail(regex, "3.2.1.GA");
        this.checkFail(regex, "3.3.0.CP1");
        regex = "1.[01234].(RC1|RC2|GA)";
        this.checkOK(regex, "1.0.RC1");
        this.checkOK(regex, "1.1.RC2");
        this.checkOK(regex, "1.4.GA");
        this.checkFail(regex, "1.5.GA");
        regex = "(3.2.0.(GA|CP[12345]))|(1.[01234].(RC1|RC2|GA))";
        this.checkOK(regex, "3.2.0.GA");
        this.checkOK(regex, "3.2.0.CP1");
        this.checkOK(regex, "3.2.0.CP5");
        this.checkFail(regex, "3.2.1.GA");
        this.checkFail(regex, "3.3.0.CP1");
        this.checkOK(regex, "1.0.RC1");
        this.checkOK(regex, "1.1.RC2");
        this.checkOK(regex, "1.4.GA");
        this.checkFail(regex, "1.5.GA");
        regex = "cafebabe0|cafebabe1|cafebabe2|abcdef8";
        this.checkOK(regex, "cafebabe0");
        this.checkOK(regex, "cafebabe1");
        this.checkOK(regex, "cafebabe2");
        this.checkOK(regex, "abcdef8");
        this.checkFail(regex, "cafebabe9");
        regex = ".*(cafebabe0|cafebabe1|cafebabe2|abcdef8).*";
        this.checkOK(regex, "test:cafebabe0");
        this.checkOK(regex, "abeabe\\:cafebabe1");
        this.checkOK(regex, "cafebabe2");
        this.checkOK(regex, "abcdef8");
        this.checkFail(regex, "cafebabe9");
    }

    public void testLatestAgentBuildCheckRegex() {
        String regexOptions = "cafebabe0|3degf01|cafebabe9";
        AgentVersion agentVersionInfo = this.setSupportedBuildsToCheck(regexOptions, "1.0.GA", "cafebabe0");
        assert (this.agentManager.isAgentVersionSupported(agentVersionInfo).isSupported());
        agentVersionInfo = this.setSupportedBuildsToCheck(regexOptions, "1.0.RC1", "cafebabe1");
        assert (!this.agentManager.isAgentVersionSupported(agentVersionInfo).isSupported());
        agentVersionInfo = this.setSupportedBuildsToCheck(regexOptions, "2.0.GA", "3deg");
        assert (!this.agentManager.isAgentVersionSupported(agentVersionInfo).isSupported());
    }

    private void checkOK(String supportedBuilds, String agentBuildToCheck) {
        this.check(supportedBuilds, agentBuildToCheck, true);
    }

    private void checkFail(String supportedBuilds, String agentBuildToCheck) {
        this.check(supportedBuilds, agentBuildToCheck, false);
    }

    private void check(String supportedBuilds, String agentBuildToCheck, boolean expectedResult) {
        AgentVersion agentVersionInfo = this.setSupportedBuildsToCheck(supportedBuilds, "", agentBuildToCheck);
        assert (expectedResult == this.agentManager.isAgentVersionSupported(agentVersionInfo).isSupported()) : "supportedBuilds=" + supportedBuilds + "; agentBuildToCheck=" + agentBuildToCheck;
    }

    private AgentVersion setSupportedBuildsToCheck(String supportedBuildsRegex, String agentVersionToCheck, String agentBuildToCheck) {
        this.supportedBuildsRegex = supportedBuildsRegex;
        return new AgentVersion(agentVersionToCheck, agentBuildToCheck);
    }

    private AgentVersion setLatestAgentVersionAndBuildToCheck(String agentLatestVersion, String agentLatestBuild, String agentVersionToCheck, String agentBuildToCheck) {
        this.supportedBuildsRegex = null;
        this.agentLatestBuild = agentLatestBuild;
        this.agentLatestVersion = agentLatestVersion;
        return new AgentVersion(agentVersionToCheck, agentBuildToCheck);
    }

    private class AgentManagerStub
    extends AgentManagerBean {
        private AgentManagerStub() {
        }

        public Properties getAgentUpdateVersionFileContent() {
            String RHQ_AGENT_LATEST_BUILD = "rhq-agent.latest.build-number";
            String RHQ_AGENT_LATEST_VERSION = "rhq-agent.latest.version";
            String RHQ_AGENT_SUPPORTED_BUILDS = "rhq-agent.supported.builds";
            Properties p = new Properties();
            p.put("rhq-agent.latest.version", AgentSupportedBuildTest.this.agentLatestVersion);
            p.put("rhq-agent.latest.build-number", AgentSupportedBuildTest.this.agentLatestBuild);
            if (AgentSupportedBuildTest.this.supportedBuildsRegex != null) {
                p.put("rhq-agent.supported.builds", AgentSupportedBuildTest.this.supportedBuildsRegex);
            }
            return p;
        }
    }
}

