/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.legacy.rss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class DownloadPatchTest {
    private Log log = LogFactory.getLog((String)DownloadPatchTest.class.getName());
    private static final String URL = "https://network.staging.jboss.com/jbossnetwork/secureDownload.html";
    private HttpClient client;

    protected void setUp() throws Exception {
        this.client = new HttpClient();
    }

    protected void tearDown() throws Exception {
        this.client = null;
    }

    private void assertEquals(Object o1, Object o2) {
    }

    public void testAccessDownloadsNoUser() throws Exception {
        int statusCode = this.accessDownload("", "", "");
        this.assertEquals(403, statusCode);
    }

    public void testAccessDownloadsNoPassword() throws Exception {
        int statusCode = this.accessDownload("fmerenda@jboss.org", "", "");
        this.assertEquals(403, statusCode);
    }

    public void testAccessDownloadsInvalidPassword() throws Exception {
        int statusCode = this.accessDownload("fmerenda@jboss.org", "xxxxx", "");
        this.assertEquals(403, statusCode);
    }

    public void testAccessDownloadsNoSoftware() throws Exception {
        int statusCode = this.accessDownload("fmerenda@jboss.org", "password", "");
        this.assertEquals(404, statusCode);
    }

    public void testAccessDownloadsInvalidSoftware() throws Exception {
        int statusCode = this.accessDownload("fmerenda@jboss.org", "password", "xxxx");
        this.assertEquals(404, statusCode);
    }

    public void testAccessDownloadsValidSoftware() throws Exception {
        int fileSize = this.accessDownloadGetFileSize("fmerenda@jboss.org", "password", "a0450000005izHvAAI");
        this.assertEquals(330322, fileSize);
    }

    private int accessDownload(String username, String password, String softwareId) throws Exception {
        GetMethod method = new GetMethod(URL);
        method.addRequestHeader("username", username);
        method.addRequestHeader("password", password);
        method.setFollowRedirects(true);
        NameValuePair softwarePair = new NameValuePair("softwareId", softwareId);
        method.setQueryString(new NameValuePair[]{softwarePair});
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            this.log.debug((Object)("Method status: " + method.getStatusLine()));
            if (200 == statusCode) {
                String content = this.readContent(method);
                this.log.debug((Object)("file length: " + content.length()));
            }
            int n = statusCode;
            return n;
        }
        catch (Exception e) {
            this.log.error((Object)e.toString());
            throw e;
        }
        finally {
            method.releaseConnection();
        }
    }

    private int accessDownloadGetFileSize(String username, String password, String softwareId) throws Exception {
        GetMethod method = new GetMethod(URL);
        method.addRequestHeader("username", username);
        method.addRequestHeader("password", password);
        method.setFollowRedirects(true);
        NameValuePair softwarePair = new NameValuePair("softwareId", softwareId);
        method.setQueryString(new NameValuePair[]{softwarePair});
        try {
            int contentLength = 0;
            int statusCode = this.client.executeMethod((HttpMethod)method);
            this.log.debug((Object)("Method status: " + method.getStatusLine()));
            if (200 == statusCode) {
                String content = this.readContent(method);
                contentLength = content.length();
            }
            int n = contentLength;
            return n;
        }
        catch (Exception e) {
            this.log.error((Object)e.toString());
            throw e;
        }
        finally {
            method.releaseConnection();
        }
    }

    private String readContent(GetMethod get) throws IOException {
        StringBuffer result = new StringBuffer();
        try {
            int charsRead;
            InputStreamReader input = new InputStreamReader(get.getResponseBodyAsStream(), get.getResponseCharSet());
            BufferedReader bufferedReader = input instanceof BufferedReader ? (BufferedReader)((Object)input) : new BufferedReader(input);
            char[] buffer = new char[4096];
            while ((charsRead = bufferedReader.read(buffer)) != -1) {
                result.append(buffer, 0, charsRead);
            }
        }
        catch (UnsupportedEncodingException e) {
            result.append(get.getResponseBodyAsString());
        }
        return result.toString();
    }
}

