/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.jboss.as.naming.InitialContextFactory;
import org.rhq.enterprise.server.naming.AccessCheckingInitialContextFactoryBuilder;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class DecoratingInvocationHandlerTest {
    private static final Set<String> INVOKED_METHODS = new HashSet<String>();
    private static final InvocationHandler NOTE_TAKING_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            INVOKED_METHODS.add(method.getName());
            if ("hashCode".equals(method.getName())) {
                return 0;
            }
            if ("equals".equals(method.getName())) {
                return false;
            }
            return null;
        }
    };
    private static Class<?>[] CONTEXT_INTERFACES;

    @BeforeClass
    public void setBuilder() throws Exception {
        NamingManager.setInitialContextFactoryBuilder((InitialContextFactoryBuilder)new AccessCheckingInitialContextFactoryBuilder((javax.naming.spi.InitialContextFactory)new InitialContextFactory(), false));
    }

    public void testSimpleDispatch() throws Exception {
        INVOKED_METHODS.clear();
        Properties env = new Properties();
        env.put("java.naming.factory.initial", Factory.class.getName());
        CONTEXT_INTERFACES = new Class[]{Context.class};
        InitialContext ctx = new InitialContext(env);
        ctx.lookup("asdf");
        assert (INVOKED_METHODS.contains("lookup")) : "The lookup doesn't seem to have propagated to the actual context to be used.";
    }

    public void testMultiInterfaceDispatch() throws Exception {
        INVOKED_METHODS.clear();
        Properties env = new Properties();
        env.put("java.naming.factory.initial", Factory.class.getName());
        CONTEXT_INTERFACES = new Class[]{EventContext.class, DirContext.class};
        InitialContext ctx = new InitialContext(env);
        ctx.lookup("asdf");
        DummyInitialEventContext ectx = new DummyInitialEventContext(env);
        ectx.addNamingListener("hodiny", 0, null);
        assert (INVOKED_METHODS.contains("lookup")) : "The lookup doesn't seem to have propagated to the actual context to be used.";
        assert (INVOKED_METHODS.contains("addNamingListener")) : "The addNamingListener doesn't seem to have propagated to the actual context to be used.";
    }

    private static class DummyInitialEventContext
    extends InitialContext
    implements EventContext {
        public DummyInitialEventContext(Hashtable<?, ?> environment) throws NamingException {
            super(environment);
        }

        @Override
        public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
            ((EventContext)this.getURLOrDefaultInitCtx(target)).addNamingListener(target, scope, l);
        }

        @Override
        public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
            ((EventContext)this.getURLOrDefaultInitCtx(target)).addNamingListener(target, scope, l);
        }

        @Override
        public void removeNamingListener(NamingListener l) throws NamingException {
            ((EventContext)this.getDefaultInitCtx()).removeNamingListener(l);
        }

        @Override
        public boolean targetMustExist() throws NamingException {
            return ((EventContext)this.getDefaultInitCtx()).targetMustExist();
        }
    }

    public static class Factory
    implements javax.naming.spi.InitialContextFactory {
        @Override
        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
            return (Context)Proxy.newProxyInstance(DecoratingInvocationHandlerTest.class.getClassLoader(), CONTEXT_INTERFACES, NOTE_TAKING_HANDLER);
        }
    }
}

