/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.rhq.enterprise.server.search.RHQLLexer;
import org.rhq.enterprise.server.search.RHQLParser;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RHQLTest
extends AssertJUnit {
    private ExecutorService executor;

    @BeforeClass
    public void init() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public void teardown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSingleLineRHQL() throws Exception {
        BufferedReader reader = null;
        ArrayList<String> successes = new ArrayList<String>();
        ArrayList<String> failures = new ArrayList<String>();
        int count = 0;
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("single-line-rhql.txt");
            reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            long timeout = 2000L;
            while ((line = reader.readLine()) != null) {
                TestResult result = this.testSuccess(line, timeout);
                if (result == TestResult.SKIPPED) continue;
                ++count;
                if (result == TestResult.SUCCESS) {
                    successes.add(line);
                    continue;
                }
                if (result == TestResult.FAILURE) {
                    failures.add(line);
                    continue;
                }
                if (result != TestResult.TIMEOUT) continue;
                System.out.println("Parsing took more than " + timeout + "ms, does your grammar have an infinite loop?");
            }
        }
        catch (Exception e) {
            System.out.println("Error testing single line RHQL: " + e);
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        System.out.println();
        for (String success : successes) {
            System.out.println("Parse success: " + success);
        }
        for (String failure : failures) {
            System.out.println("Parse failure: " + failure);
        }
        System.out.println();
        System.out.printf("RHQL expressions parsed: %1$s, Failures: %2$s", count, failures.size());
        System.out.println();
        assert (failures.size() == 0);
    }

    private TestResult testSuccess(String line, long timeout) {
        if (this.shouldSkip(line)) {
            return TestResult.SKIPPED;
        }
        AntlrTask task = new AntlrTask(line);
        Future<TestResult> futureTask = this.executor.submit(task);
        TestResult result = null;
        try {
            result = futureTask.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
        }
        catch (TimeoutException te) {
            futureTask.cancel(true);
            result = TestResult.TIMEOUT;
        }
        catch (InterruptedException ie) {
            futureTask.cancel(true);
        }
        return result;
    }

    private boolean shouldSkip(String line) {
        if ((line = line.trim()).equals("")) {
            return true;
        }
        return line.startsWith("#");
    }

    private class AntlrTask
    implements Callable<TestResult> {
        private String line;

        public AntlrTask(String line) {
            this.line = line;
        }

        @Override
        public TestResult call() throws Exception {
            try {
                System.out.println(this.line);
                ANTLRStringStream input = new ANTLRStringStream(this.line);
                RHQLLexer lexer = new RHQLLexer((CharStream)input);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                RHQLParser parser = new RHQLParser((TokenStream)tokens);
                RHQLParser.searchExpression_return parseResults = parser.searchExpression();
                System.out.println(parseResults.tree.toStringTree());
                return TestResult.SUCCESS;
            }
            catch (Throwable t) {
                return TestResult.FAILURE;
            }
        }
    }

    private static enum TestResult {
        SUCCESS,
        FAILURE,
        TIMEOUT,
        SKIPPED;

    }
}

