/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.enterprise.server.sync.ExportingInputStream;
import org.rhq.enterprise.server.sync.SystemSettingsSynchronizer;
import org.rhq.enterprise.server.sync.test.MetricTemplateExporterTest;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.test.JMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Test
public class SystemSettingsExporterTest
extends JMockTest {
    private static final Log LOG = LogFactory.getLog(MetricTemplateExporterTest.class);

    public void testCanExport() throws Exception {
        final SystemManagerLocal systemManager = (SystemManagerLocal)this.context.mock(SystemManagerLocal.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SystemManagerLocal)this.allowing(systemManager)).getObfuscatedSystemSettings(false);
                this.will(1.returnValue((Object)SystemSettingsExporterTest.getFakeSystemSettings()));
            }
        });
        SystemSettingsSynchronizer exporter = new SystemSettingsSynchronizer(systemManager);
        HashSet<SystemSettingsSynchronizer> exporters = new HashSet<SystemSettingsSynchronizer>();
        exporters.add(exporter);
        ExportingInputStream eis = new ExportingInputStream(exporters, new HashMap(), 65536, false);
        DocumentBuilder bld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = bld.parse((InputStream)eis);
        Element root = doc.getDocumentElement();
        Element entities = (Element)SystemSettingsExporterTest.getFirstDirectChildByTagName(root, "entities");
        Assert.assertEquals((String)entities.getAttribute("id"), (String)SystemSettingsSynchronizer.class.getName(), (String)"Unexpected id of the entities element.");
        NodeList systemSettings = entities.getElementsByTagName("systemSettings");
        Assert.assertEquals((int)systemSettings.getLength(), (int)1, (String)"Unexpected number of exported system settings.");
        for (int i = 0; i < systemSettings.getLength(); ++i) {
            Element m = (Element)systemSettings.item(i);
            Assert.assertEquals((String)m.getAttribute("referencedEntityId"), (String)"0", (String)"Unexpected referencedEntityId value");
            NodeList entries = m.getElementsByTagName("entry");
            Assert.assertEquals((int)entries.getLength(), (int)1, (String)"Unexpected number of entry elements in the system settings export.");
            Element baseURL = (Element)entries.item(0);
            Assert.assertEquals((String)baseURL.getAttribute("key"), (String)"CAM_BASE_URL");
            Assert.assertEquals((String)baseURL.getTextContent(), (String)"herethereandeverywhere", (String)"Unexpected value of CAM_BASE_URL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readAll(Reader rdr) throws IOException {
        try {
            int c;
            StringBuilder bld = new StringBuilder();
            while ((c = rdr.read()) != -1) {
                bld.append((char)c);
            }
            String string = bld.toString();
            return string;
        }
        finally {
            rdr.close();
        }
    }

    private static Node getFirstDirectChildByTagName(Node node, String tagName) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = node.getChildNodes().item(i);
            if (!n.getNodeName().equals(tagName)) continue;
            return n;
        }
        return null;
    }

    private static SystemSettings getFakeSystemSettings() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("CAM_BASE_URL", "herethereandeverywhere");
        return SystemSettings.fromMap(values);
    }
}

