/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.JPADriftCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class CriteriaQueryTest {
    @Test
    public void executeQueryThatReturnsASinglePageOfResults() {
        List<FakeEntity> expected = Arrays.asList(new FakeEntity(1), new FakeEntity(2));
        FakeCriteriaQueryExecutor queryExecutor = new FakeCriteriaQueryExecutor(2, PageControl.getUnlimitedInstance());
        queryExecutor.addPage(expected);
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
        ArrayList<FakeEntity> actual = new ArrayList<FakeEntity>();
        for (FakeEntity entity : query) {
            actual.add(entity);
        }
        Assert.assertEquals(actual, expected, (String)"Failed to iterate over query results with a single page");
    }

    @Test
    public void executeQueryThatReturnsMultiplePagesOfResults() {
        PageControl pc = new PageControl(0, 2);
        List<FakeEntity> expected = Arrays.asList(new FakeEntity(1), new FakeEntity(2), new FakeEntity(3), new FakeEntity(4));
        FakeCriteriaQueryExecutor queryExecutor = new FakeCriteriaQueryExecutor(4, pc);
        queryExecutor.addPage(expected.subList(0, 2));
        queryExecutor.addPage(expected.subList(2, 4));
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        criteria.setPaging(pc.getPageNumber(), pc.getPageSize());
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
        ArrayList<FakeEntity> actual = new ArrayList<FakeEntity>();
        for (FakeEntity entity : query) {
            actual.add(entity);
        }
        Assert.assertEquals(actual, expected);
    }

    @Test
    public void executeQueryThatReturnsTotalPagesOfResults() {
        int pageSize = 100;
        PageControl pc = new PageControl(0, pageSize);
        int totalSize = 500;
        ArrayList<FakeEntity> total = new ArrayList<FakeEntity>();
        for (int i = 0; i < totalSize; ++i) {
            total.add(new FakeEntity(i));
        }
        FakeCriteriaQueryExecutor queryExecutor = new FakeCriteriaQueryExecutor(totalSize, pc);
        int bucketCount = totalSize / pageSize;
        int start = 0;
        int end = pageSize;
        for (int i = 0; i < bucketCount; ++i) {
            queryExecutor.addPage(total.subList(start, end));
            start += pageSize;
            end += pageSize;
        }
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        criteria.setPaging(pc.getPageNumber(), pc.getPageSize());
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
        int last = -1;
        for (FakeEntity entity : query) {
            Assert.assertEquals((boolean)true, (last < entity.getId() ? 1 : 0) != 0);
            last = entity.getId();
        }
    }

    @Test
    public void testIteratingOverQueryWithInconsistentResults_fewResultsOnLastPage() {
        PageControl pc = new PageControl(0, 100);
        int realResults = 490;
        FakeCriteriaQueryExecutor executor = this.prepareExecutor(realResults, 500, pc);
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        criteria.setPaging(pc.getPageNumber(), pc.getPageSize());
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)executor);
        int num = 0;
        int last = -1;
        for (FakeEntity entity : query) {
            Assert.assertEquals((boolean)true, (last < entity.getId() ? 1 : 0) != 0);
            last = entity.getId();
            ++num;
        }
        Assert.assertEquals((int)num, (int)realResults, (String)"Unexpected number for results returned");
    }

    @Test
    public void testIteratingOVerQueryWithInconsistentResults_emptyLastPage() {
        PageControl pc = new PageControl(0, 100);
        int realResults = 400;
        FakeCriteriaQueryExecutor executor = this.prepareExecutor(realResults, 500, pc);
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        criteria.setPaging(pc.getPageNumber(), pc.getPageSize());
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)executor);
        int num = 0;
        int last = -1;
        for (FakeEntity entity : query) {
            Assert.assertEquals((boolean)true, (last < entity.getId() ? 1 : 0) != 0);
            last = entity.getId();
            ++num;
        }
        Assert.assertEquals((int)num, (int)realResults, (String)"Unexpected number for results returned");
    }

    @Test
    public void testIteratingOverQueryWithInconsistentResults_tooManyResults() {
        PageControl pc = new PageControl(0, 100);
        int realResults = 551;
        FakeCriteriaQueryExecutor executor = this.prepareExecutor(realResults, 520, pc);
        FakeEntityCriteria criteria = new FakeEntityCriteria();
        criteria.setPaging(pc.getPageNumber(), pc.getPageSize());
        CriteriaQuery query = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)executor);
        int num = 0;
        int last = -1;
        for (FakeEntity entity : query) {
            Assert.assertEquals((boolean)true, (last < entity.getId() ? 1 : 0) != 0);
            last = entity.getId();
            ++num;
        }
        Assert.assertEquals((int)num, (int)realResults, (String)"Unexpected number for results returned");
    }

    @Test
    public void singleResultTest() {
        block15: {
            ArrayList<FakeEntity> result;
            block14: {
                block13: {
                    block12: {
                        result = null;
                        try {
                            FakeEntityCriteria.getSingleResult(result);
                            assert (false) : "Should have thrown Runtime Exception";
                        }
                        catch (RuntimeException e) {
                            if ($assertionsDisabled || e.getMessage().contains("NoResultException")) break block12;
                            throw new AssertionError();
                        }
                    }
                    result = new ArrayList<FakeEntity>(2);
                    try {
                        FakeEntityCriteria.getSingleResult(result);
                        assert (false) : "Should have thrown Runtime Exception";
                    }
                    catch (RuntimeException e) {
                        if ($assertionsDisabled || e.getMessage().contains("NoResultException")) break block13;
                        throw new AssertionError();
                    }
                }
                result.add(new FakeEntity(1));
                try {
                    FakeEntity r = (FakeEntity)FakeEntityCriteria.getSingleResult(result);
                    assert (r.getId() == 1) : "Should have retuned expected entity but returned: " + r;
                }
                catch (Throwable t) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"Should have returned single result");
                }
            }
            result.add(new FakeEntity(2));
            try {
                FakeEntityCriteria.getSingleResult(result);
                assert (false) : "Should have thrown Runtime Exception";
            }
            catch (RuntimeException e) {
                if ($assertionsDisabled || e.getMessage().contains("NonUniqueResultException")) break block15;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testAddSort() {
        JPADriftCriteria c;
        try {
            c = new JPADriftCriteria();
            c.addSortId(PageOrdering.ASC);
            AssertJUnit.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        c = new ResourceCriteria();
        c.addSortName(PageOrdering.ASC);
        Assert.assertEquals((int)2, (int)CriteriaQueryGenerator.getPageControl((Criteria)c).getOrderingFields().size());
        Assert.assertEquals((String)"name", (String)((OrderingField)CriteriaQueryGenerator.getPageControl((Criteria)c).getOrderingFields().get(0)).getField());
        Assert.assertEquals((String)"id", (String)((OrderingField)CriteriaQueryGenerator.getPageControl((Criteria)c).getOrderingFields().get(1)).getField());
    }

    private FakeCriteriaQueryExecutor prepareExecutor(int realTotalSize, int reportedTotalSize, PageControl pc) {
        FakeCriteriaQueryExecutor executor = new FakeCriteriaQueryExecutor(reportedTotalSize, pc);
        ArrayList<FakeEntity> page = new ArrayList<FakeEntity>(pc.getPageSize());
        for (int i = 0; i < realTotalSize; ++i) {
            if (i != 0 && i % pc.getPageSize() == 0) {
                executor.addPage(page);
                page.clear();
            }
            page.add(new FakeEntity(i));
        }
        if (realTotalSize != reportedTotalSize) {
            executor.addPage(page);
        }
        return executor;
    }

    private static class FakeCriteriaQueryExecutor
    implements CriteriaQueryExecutor<FakeEntity, FakeEntityCriteria> {
        private List<PageList<FakeEntity>> pages = new ArrayList<PageList<FakeEntity>>();
        private int totalSize;
        private PageControl pc;

        public FakeCriteriaQueryExecutor(int totalSize, PageControl pc) {
            this.totalSize = totalSize;
            this.pc = pc;
        }

        public void addPage(List<FakeEntity> entities) {
            int pageNumber = this.pages.size();
            this.pages.add((PageList<FakeEntity>)new PageList(entities, this.totalSize, new PageControl(pageNumber, this.pc.getPageSize())));
        }

        public PageList<FakeEntity> execute(FakeEntityCriteria criteria) {
            int page = criteria.getPageNumber();
            return this.pages.size() > page ? this.pages.get(page) : new PageList(new PageControl(page, this.pc.getPageSize()));
        }
    }

    private static class FakeEntityCriteria
    extends Criteria {
        private FakeEntityCriteria() {
        }

        public Class<?> getPersistentClass() {
            return FakeEntity.class;
        }
    }

    private static class FakeEntity {
        private int id;

        public FakeEntity(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

