/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.PhantomReadMaxAttemptsExceededException;
import org.rhq.enterprise.server.util.QueryUtility;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class QueryUtilityTest {
    private int[] attemptCounters;
    private Query dataQuery;
    private Query countQuery;
    private int numberOfInconsistentResults;

    @BeforeClass
    public void setupMocks() {
        this.attemptCounters = new int[2];
        this.dataQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.dataQuery.getResultList()).then(new Answer<List<?>>(){

            public List<?> answer(InvocationOnMock invocation) throws Throwable {
                int[] nArray = QueryUtilityTest.this.attemptCounters;
                int n = nArray[0];
                nArray[0] = n + 1;
                int attempt = n;
                if (attempt < QueryUtilityTest.this.numberOfInconsistentResults) {
                    return Collections.emptyList();
                }
                if (attempt < QueryUtility.PHANTOM_READ_MAX_ATTEMPTS) {
                    return Collections.singletonList(this);
                }
                throw new AssertionError((Object)("Shouldn't have been called more than " + QueryUtility.PHANTOM_READ_MAX_ATTEMPTS + " times"));
            }
        });
        this.countQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.countQuery.getSingleResult()).then((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                int[] nArray = QueryUtilityTest.this.attemptCounters;
                int n = nArray[1];
                nArray[1] = n + 1;
                if (n < QueryUtility.PHANTOM_READ_MAX_ATTEMPTS) {
                    return 1L;
                }
                throw new AssertionError((Object)("Shouldn't have been called more than " + QueryUtility.PHANTOM_READ_MAX_ATTEMPTS + " times"));
            }
        });
    }

    @BeforeMethod
    public void resetAttemptCounters() {
        for (int i = 0; i < this.attemptCounters.length; ++i) {
            this.attemptCounters[i] = 0;
        }
    }

    public void defaultPagedDataFetchSettings() {
        QueryUtility.PagedDataFetchSettings settings = new QueryUtility.PagedDataFetchSettings();
        Assert.assertEquals((int)settings.getMaxAttempts(), (int)QueryUtility.PHANTOM_READ_MAX_ATTEMPTS, (String)"Wrong default max attempts");
        Assert.assertEquals((int)settings.getMinWaitTime(), (int)QueryUtility.PHANTOM_READ_MIN_WAIT_TIME, (String)"Wrong default min wait time");
        Assert.assertEquals((int)settings.getMaxWaitTime(), (int)QueryUtility.PHANTOM_READ_MAX_WAIT_TIME, (String)"Wrong default max wait time");
        Assert.assertFalse((boolean)settings.isThrowOnMaxAttempts(), (String)"Wrong default throw on max attempts");
    }

    public void lagCoefficientForPagedDataFetch() {
        QueryUtility.PagedDataFetchSettings settings = new QueryUtility.PagedDataFetchSettings();
        settings.setMaxAttempts(10);
        settings.setMinWaitTime(1);
        settings.setMaxWaitTime(10);
        float lag = settings.getLagIncreaseCoefficient();
        Assert.assertEquals((Object)Float.valueOf(lag), (Object)Float.valueOf((float)Math.pow(10.0, 0.125)), (String)"Unexpected lag computed");
    }

    public void dataFetchPerformsMaxAttemptsOnInconsistentResults() {
        this.numberOfInconsistentResults = 10;
        PageControl pc = PageControl.getUnlimitedInstance();
        PageList result = QueryUtility.fetchPagedDataAndCount((Query)this.dataQuery, (Query)this.countQuery, (PageControl)pc, null);
        Assert.assertEquals((Collection)result, Collections.emptyList(), (String)"The result should be empty");
        Assert.assertEquals((int)result.getTotalSize(), (int)1, (String)"Unexpected total size");
        Assert.assertFalse((boolean)result.isConsistent(), (String)"The result should be inconsistent");
        Assert.assertEquals((int)this.attemptCounters[0], (int)QueryUtility.PHANTOM_READ_MAX_ATTEMPTS);
        Assert.assertEquals((int)this.attemptCounters[1], (int)QueryUtility.PHANTOM_READ_MAX_ATTEMPTS);
    }

    public void dataFetchReturnsConsistentResultsWhenDetected() {
        this.numberOfInconsistentResults = 2;
        PageControl pc = PageControl.getUnlimitedInstance();
        PageList result = QueryUtility.fetchPagedDataAndCount((Query)this.dataQuery, (Query)this.countQuery, (PageControl)pc, null);
        Assert.assertEquals((int)result.size(), (int)1, (String)"The result should have 1 element");
        Assert.assertEquals((int)result.getTotalSize(), (int)1, (String)"Unexpected total size");
        Assert.assertTrue((boolean)result.isConsistent(), (String)"The result should be consistent");
        Assert.assertEquals((int)this.attemptCounters[0], (int)(this.numberOfInconsistentResults + 1));
        Assert.assertEquals((int)this.attemptCounters[1], (int)(this.numberOfInconsistentResults + 1));
    }

    public void dataFetchThrowsAfterMaxAttemptsWhenSetUpSo() {
        this.numberOfInconsistentResults = 10;
        PageControl pc = PageControl.getUnlimitedInstance();
        QueryUtility.PagedDataFetchSettings settings = new QueryUtility.PagedDataFetchSettings();
        settings.setThrowOnMaxAttempts(true);
        try {
            QueryUtility.fetchPagedDataAndCount((Query)this.dataQuery, (Query)this.countQuery, (PageControl)pc, (QueryUtility.PagedDataFetchSettings)settings);
            Assert.fail((String)"Fetch should have thrown an exception after max attempts");
        }
        catch (PhantomReadMaxAttemptsExceededException e) {
            PageList result = e.getList();
            Assert.assertEquals((Collection)result, Collections.emptyList(), (String)"The result should be empty");
            Assert.assertEquals((int)result.getTotalSize(), (int)1, (String)"Unexpected total size");
            Assert.assertFalse((boolean)result.isConsistent(), (String)"The result should be inconsistent");
        }
        Assert.assertEquals((int)this.attemptCounters[0], (int)QueryUtility.PHANTOM_READ_MAX_ATTEMPTS);
        Assert.assertEquals((int)this.attemptCounters[1], (int)QueryUtility.PHANTOM_READ_MAX_ATTEMPTS);
    }

    public void repeatedFetchesWaitLongEnough() {
        QueryUtility.PagedDataFetchSettings unusedSettings;
        this.numberOfInconsistentResults = 10;
        PageControl pc = PageControl.getUnlimitedInstance();
        long time = System.currentTimeMillis();
        PageList result = QueryUtility.fetchPagedDataAndCount((Query)this.dataQuery, (Query)this.countQuery, (PageControl)pc, null);
        time = System.currentTimeMillis() - time;
        Assert.assertTrue((time >= (unusedSettings = new QueryUtility.PagedDataFetchSettings()).getMinimumTotalWaitTime() ? 1 : 0) != 0, (String)("The fetch should have spent more time trying. Was " + time + "ms, but should have been at least " + unusedSettings.getMinimumTotalWaitTime() + "ms"));
        Assert.assertEquals((Collection)result, Collections.emptyList(), (String)"The result should be empty");
        Assert.assertEquals((int)result.getTotalSize(), (int)1, (String)"Unexpected total size");
        Assert.assertFalse((boolean)result.isConsistent(), (String)"The result should be inconsistent");
        Assert.assertEquals((int)this.attemptCounters[0], (int)QueryUtility.PHANTOM_READ_MAX_ATTEMPTS);
        Assert.assertEquals((int)this.attemptCounters[1], (int)QueryUtility.PHANTOM_READ_MAX_ATTEMPTS);
    }
}

