/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth;

import org.rhq.core.domain.auth.Subject;

class AuthSession {
    private long _timeout;
    private Subject _subject;
    private long _lastAccess;

    protected AuthSession(Subject subject, long timeout) {
        this._subject = subject;
        this._timeout = timeout;
        this._lastAccess = System.currentTimeMillis();
    }

    protected Subject getSubject(boolean updateLastAccessTime) {
        if (updateLastAccessTime) {
            this._lastAccess = System.currentTimeMillis();
        }
        return this._subject;
    }

    protected boolean isExpired() {
        return System.currentTimeMillis() > this._lastAccess + this._timeout;
    }

    public long getLastAccess() {
        return this._lastAccess;
    }
}

