/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.ArrayList;
import java.util.List;
import org.rhq.core.domain.cloud.AffinityGroup;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.core.domain.resource.Agent;

public class ServerBucket {
    Server server;
    FailoverListComposite.ServerEntry serverEntry;
    int computePower;
    double assignedLoad;
    List<Agent> assignedAgents;

    ServerBucket(Server server) {
        this.server = server;
        this.serverEntry = server.getServerEntry();
        this.computePower = 1;
        this.assignedLoad = 0.0;
        this.assignedAgents = new ArrayList<Agent>();
    }

    public String toString() {
        return this.serverEntry.toString();
    }

    static ServerBucket getBestBucket(List<ServerBucket> buckets, List<ServerBucket> usedBuckets, AffinityGroup affinityGroup, String preferredServerName) {
        ServerBucket result = null;
        if (null != preferredServerName && null == ServerBucket.getBucketByName(usedBuckets, preferredServerName) && null != (result = ServerBucket.getBucketByName(buckets, preferredServerName)) && null != affinityGroup && !affinityGroup.equals((Object)result.server.getAffinityGroup())) {
            result = null;
        }
        if (null != result) {
            return result;
        }
        for (ServerBucket next : buckets) {
            if (null != ServerBucket.getBucketByName(usedBuckets, next.server.getName())) continue;
            if (null == result) {
                result = next;
                continue;
            }
            if (null == affinityGroup) {
                if (!(next.assignedLoad < result.assignedLoad)) continue;
                result = next;
                continue;
            }
            if (!affinityGroup.equals((Object)result.server.getAffinityGroup())) {
                if (affinityGroup.equals((Object)next.server.getAffinityGroup())) {
                    result = next;
                    continue;
                }
                if (!(next.assignedLoad < result.assignedLoad)) continue;
                result = next;
                continue;
            }
            if (!affinityGroup.equals((Object)next.server.getAffinityGroup()) || !(next.assignedLoad < result.assignedLoad)) continue;
            result = next;
        }
        return result;
    }

    static ServerBucket getBucketByName(List<ServerBucket> buckets, String serverName) {
        for (ServerBucket next : buckets) {
            if (!next.server.getName().equals(serverName)) continue;
            return next;
        }
        return null;
    }
}

